/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.table;

import alluxio.Server;
import alluxio.client.job.JobMasterClient;
import alluxio.clock.SystemClock;
import alluxio.exception.ExceptionMessage;
import alluxio.grpc.GrpcService;
import alluxio.grpc.ServiceType;
import alluxio.grpc.table.ColumnStatisticsInfo;
import alluxio.grpc.table.ColumnStatisticsList;
import alluxio.grpc.table.Constraint;
import alluxio.grpc.table.Database;
import alluxio.grpc.table.Partition;
import alluxio.grpc.table.SyncStatus;
import alluxio.master.AbstractMaster;
import alluxio.master.MasterContext;
import alluxio.master.journal.DelegatingJournaled;
import alluxio.master.journal.JournalContext;
import alluxio.master.journal.Journaled;
import alluxio.master.journal.JournaledGroup;
import alluxio.master.journal.checkpoint.CheckpointName;
import alluxio.master.table.AlluxioCatalog;
import alluxio.master.table.Table;
import alluxio.master.table.TableMaster;
import alluxio.master.table.TableMasterClientServiceHandler;
import alluxio.master.table.transform.TransformJobInfo;
import alluxio.master.table.transform.TransformManager;
import alluxio.security.authentication.ClientContextServerInjector;
import alluxio.table.common.transform.TransformDefinition;
import alluxio.util.executor.ExecutorServiceFactories;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import io.grpc.BindableService;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import java.io.IOException;
import java.time.Clock;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTableMaster
extends AbstractMaster
implements TableMaster,
DelegatingJournaled {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTableMaster.class);
    private static final Set<Class<? extends Server>> DEPS = ImmutableSet.of();
    public static final String DEFAULT_TRANSFORMATION = "file.count.max=100";
    private final AlluxioCatalog mCatalog = new AlluxioCatalog();
    private final TransformManager mTransformManager;
    private final JournaledGroup mJournaledComponents;

    public DefaultTableMaster(MasterContext context, JobMasterClient jobMasterClient) {
        super(context, (Clock)new SystemClock(), ExecutorServiceFactories.cachedThreadPool((String)"TableMaster"));
        this.mTransformManager = new TransformManager(() -> ((DefaultTableMaster)this).createJournalContext(), this.mCatalog, jobMasterClient);
        this.mJournaledComponents = new JournaledGroup((List)Lists.newArrayList((Object[])new Journaled[]{this.mCatalog, this.mTransformManager}), CheckpointName.TABLE_MASTER);
    }

    @Override
    public SyncStatus attachDatabase(String udbType, String udbConnectionUri, String udbDbName, String dbName, Map<String, String> configuration, boolean ignoreSyncErrors) throws IOException {
        try (JournalContext journalContext = this.createJournalContext();){
            SyncStatus syncStatus = this.mCatalog.attachDatabase(journalContext, udbType, udbConnectionUri, udbDbName, dbName, configuration, ignoreSyncErrors);
            return syncStatus;
        }
    }

    @Override
    public boolean detachDatabase(String dbName) throws IOException {
        try (JournalContext journalContext = this.createJournalContext();){
            boolean bl = this.mCatalog.detachDatabase(journalContext, dbName);
            return bl;
        }
    }

    @Override
    public List<String> getAllDatabases() throws IOException {
        return this.mCatalog.getAllDatabases();
    }

    @Override
    public List<String> getAllTables(String databaseName) throws IOException {
        return this.mCatalog.getAllTables(databaseName);
    }

    @Override
    public Table getTable(String dbName, String tableName) throws IOException {
        return this.mCatalog.getTable(dbName, tableName);
    }

    @Override
    public List<ColumnStatisticsInfo> getTableColumnStatistics(String dbName, String tableName, List<String> colNames) throws IOException {
        return this.mCatalog.getTableColumnStatistics(dbName, tableName, colNames);
    }

    @Override
    public List<Partition> readTable(String dbName, String tableName, Constraint constraint) throws IOException {
        return this.mCatalog.readTable(dbName, tableName, constraint);
    }

    @Override
    public Map<String, ColumnStatisticsList> getPartitionColumnStatistics(String dbName, String tableName, List<String> partNamesList, List<String> colNamesList) throws IOException {
        return this.mCatalog.getPartitionColumnStatistics(dbName, tableName, partNamesList, colNamesList);
    }

    @Override
    public long transformTable(String dbName, String tableName, String definition) throws IOException {
        if (definition == null || definition.trim().isEmpty()) {
            definition = DEFAULT_TRANSFORMATION;
        }
        TransformDefinition transformDefinition = TransformDefinition.parse((String)definition);
        return this.mTransformManager.execute(dbName, tableName, transformDefinition);
    }

    @Override
    public TransformJobInfo getTransformJobInfo(long jobId) throws IOException {
        Optional<TransformJobInfo> info = this.mTransformManager.getTransformJobInfo(jobId);
        if (!info.isPresent()) {
            throw new IOException(ExceptionMessage.TRANSFORM_JOB_DOES_NOT_EXIST.getMessage(new Object[]{jobId}));
        }
        return info.get();
    }

    @Override
    public List<TransformJobInfo> getAllTransformJobInfo() throws IOException {
        return this.mTransformManager.getAllTransformJobInfo();
    }

    @Override
    public SyncStatus syncDatabase(String dbName) throws IOException {
        try (JournalContext journalContext = this.createJournalContext();){
            SyncStatus syncStatus = this.mCatalog.syncDatabase(journalContext, dbName);
            return syncStatus;
        }
    }

    @Override
    public Database getDatabase(String dbName) throws IOException {
        return this.mCatalog.getDatabase(dbName);
    }

    public Set<Class<? extends Server>> getDependencies() {
        return DEPS;
    }

    public String getName() {
        return "TableMaster";
    }

    public Map<ServiceType, GrpcService> getServices() {
        HashMap<ServiceType, GrpcService> services = new HashMap<ServiceType, GrpcService>();
        services.put(ServiceType.TABLE_MASTER_CLIENT_SERVICE, new GrpcService(ServerInterceptors.intercept((BindableService)new TableMasterClientServiceHandler(this), (ServerInterceptor[])new ServerInterceptor[]{new ClientContextServerInjector()})));
        return services;
    }

    public void start(Boolean isLeader) throws IOException {
        super.start(isLeader);
        if (isLeader.booleanValue()) {
            this.mTransformManager.start(this.getExecutorService(), this.mMasterContext.getUserState());
        }
    }

    public void stop() throws IOException {
        super.stop();
    }

    public void close() throws IOException {
        super.close();
    }

    public Journaled getDelegate() {
        return this.mJournaledComponents;
    }
}

