/*
 * Decompiled with CFR 0.152.
 */
package alluxio.table.under.glue;

import alluxio.AlluxioURI;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.NotFoundException;
import alluxio.grpc.table.ColumnStatisticsInfo;
import alluxio.grpc.table.Layout;
import alluxio.grpc.table.PrincipalType;
import alluxio.grpc.table.layout.hive.PartitionInfo;
import alluxio.master.table.DatabaseInfo;
import alluxio.table.common.BaseProperty;
import alluxio.table.common.UdbPartition;
import alluxio.table.common.layout.HiveLayout;
import alluxio.table.common.udb.PathTranslator;
import alluxio.table.common.udb.UdbBypassSpec;
import alluxio.table.common.udb.UdbConfiguration;
import alluxio.table.common.udb.UdbContext;
import alluxio.table.common.udb.UdbTable;
import alluxio.table.common.udb.UdbUtils;
import alluxio.table.common.udb.UnderDatabase;
import alluxio.table.under.glue.GluePartition;
import alluxio.table.under.glue.GlueTable;
import alluxio.table.under.glue.GlueUtils;
import alluxio.table.under.glue.Property;
import alluxio.util.io.PathUtils;
import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.glue.AWSGlueAsync;
import com.amazonaws.services.glue.AWSGlueAsyncClientBuilder;
import com.amazonaws.services.glue.model.AWSGlueException;
import com.amazonaws.services.glue.model.Column;
import com.amazonaws.services.glue.model.Database;
import com.amazonaws.services.glue.model.EntityNotFoundException;
import com.amazonaws.services.glue.model.GetColumnStatisticsForPartitionRequest;
import com.amazonaws.services.glue.model.GetColumnStatisticsForTableRequest;
import com.amazonaws.services.glue.model.GetDatabaseRequest;
import com.amazonaws.services.glue.model.GetDatabaseResult;
import com.amazonaws.services.glue.model.GetPartitionsRequest;
import com.amazonaws.services.glue.model.GetPartitionsResult;
import com.amazonaws.services.glue.model.GetTableRequest;
import com.amazonaws.services.glue.model.GetTablesRequest;
import com.amazonaws.services.glue.model.GetTablesResult;
import com.amazonaws.services.glue.model.GlueEncryptionException;
import com.amazonaws.services.glue.model.Partition;
import com.amazonaws.services.glue.model.Table;
import com.amazonaws.services.glue.model.ValidationException;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlueDatabase
implements UnderDatabase {
    private static final Logger LOG = LoggerFactory.getLogger(GlueDatabase.class);
    private final UdbContext mUdbContext;
    private final AWSGlueAsync mGlueClient;
    private final UdbConfiguration mGlueConfiguration;
    private final String mGlueDbName;
    private final String mOwnerName = "PUBLIC_OWNER";
    private final PrincipalType mOwnerType = PrincipalType.ROLE;

    @VisibleForTesting
    protected GlueDatabase(UdbContext udbContext, UdbConfiguration glueConfig, String glueDbName) {
        this.mUdbContext = udbContext;
        this.mGlueConfiguration = glueConfig;
        this.mGlueClient = GlueDatabase.createAsyncGlueClient(glueConfig);
        this.mGlueDbName = glueDbName;
    }

    public static GlueDatabase create(UdbContext udbContext, UdbConfiguration configuration) {
        String glueDbName = udbContext.getUdbDbName();
        if (glueDbName == null || glueDbName.isEmpty()) {
            throw new IllegalArgumentException("Glue database name cannot be empty: " + glueDbName);
        }
        if (configuration.get((BaseProperty)Property.GLUE_REGION) == null) {
            throw new IllegalArgumentException("GlueUdb Error: Please setup aws region.");
        }
        return new GlueDatabase(udbContext, configuration, glueDbName);
    }

    public UdbContext getUdbContext() {
        return this.mUdbContext;
    }

    public DatabaseInfo getDatabaseInfo() throws IOException {
        try {
            GetDatabaseRequest dbRequest = new GetDatabaseRequest().withCatalogId(this.mGlueConfiguration.get((BaseProperty)Property.CATALOG_ID)).withName(this.mGlueDbName);
            GetDatabaseResult dbResult = this.mGlueClient.getDatabase(dbRequest);
            Database glueDatabase = dbResult.getDatabase();
            String glueDbLocation = glueDatabase.getLocationUri() == null ? "" : glueDatabase.getLocationUri();
            String glueDbDescription = glueDatabase.getDescription() == null ? "" : glueDatabase.getDescription();
            HashMap glueParameters = new HashMap();
            if (glueDatabase.getParameters() != null) {
                glueParameters.putAll(glueDatabase.getParameters());
            }
            return new DatabaseInfo(glueDbLocation, "PUBLIC_OWNER", this.mOwnerType, glueDbDescription, glueParameters);
        }
        catch (EntityNotFoundException e) {
            throw new IOException("Cannot find glue database: " + this.mGlueDbName + "Catalog ID: " + this.mGlueConfiguration.get((BaseProperty)Property.CATALOG_ID) + ". " + e.getMessage(), e);
        }
    }

    protected static AWSGlueAsync createAsyncGlueClient(UdbConfiguration config) {
        ClientConfiguration clientConfig = new ClientConfiguration().withMaxConnections(config.getInt((BaseProperty)Property.MAX_GLUE_CONNECTION));
        if (!config.get((BaseProperty)Property.AWS_PROXY_HOST).isEmpty()) {
            clientConfig.withProxyProtocol(GlueDatabase.getProtocol(config.get((BaseProperty)Property.AWS_PROXY_PROTOCOL))).withProxyHost(config.get((BaseProperty)Property.AWS_PROXY_HOST)).withProxyPort(config.getInt((BaseProperty)Property.AWS_PROXY_PORT)).withProxyUsername(config.get((BaseProperty)Property.AWS_PROXY_USER_NAME)).withProxyPassword(config.get((BaseProperty)Property.AWS_PROXY_PASSWORD));
        }
        AWSGlueAsyncClientBuilder asyncClientBuilder = (AWSGlueAsyncClientBuilder)AWSGlueAsyncClientBuilder.standard().withClientConfiguration(clientConfig);
        if (!config.get((BaseProperty)Property.GLUE_REGION).isEmpty()) {
            LOG.info("Set Glue region: {}.", (Object)config.get((BaseProperty)Property.GLUE_REGION));
            asyncClientBuilder.setRegion(config.get((BaseProperty)Property.GLUE_REGION));
        } else {
            LOG.warn("GlueDatabase: Please setup the AWS region.");
        }
        asyncClientBuilder.setCredentials(GlueDatabase.getAWSCredentialsProvider(config));
        return (AWSGlueAsync)asyncClientBuilder.build();
    }

    private static AWSCredentialsProvider getAWSCredentialsProvider(UdbConfiguration config) {
        if (!config.get((BaseProperty)Property.AWS_GLUE_ACCESS_KEY).isEmpty() && !config.get((BaseProperty)Property.AWS_GLUE_SECRET_KEY).isEmpty()) {
            return new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(config.get((BaseProperty)Property.AWS_GLUE_ACCESS_KEY), config.get((BaseProperty)Property.AWS_GLUE_SECRET_KEY)));
        }
        return DefaultAWSCredentialsProviderChain.getInstance();
    }

    private static Protocol getProtocol(String protocol) {
        if (protocol.equals("HTTP")) {
            return Protocol.HTTP;
        }
        if (protocol.equals("HTTPS")) {
            return Protocol.HTTPS;
        }
        LOG.warn("Invalid protocol type {}.Avaiable proxy protocol type HTTP and HTTPS.", (Object)protocol);
        return null;
    }

    public String getType() {
        return "glue";
    }

    public String getName() {
        return this.mGlueDbName;
    }

    public List<String> getTableNames() throws IOException {
        try {
            GetTablesResult tablesResult;
            String nextToken = null;
            ArrayList<String> tableNames = new ArrayList<String>();
            do {
                GetTablesRequest tablesRequest = new GetTablesRequest().withCatalogId(this.mGlueConfiguration.get((BaseProperty)Property.CATALOG_ID)).withDatabaseName(this.mGlueDbName).withNextToken(nextToken);
                tablesResult = this.mGlueClient.getTables(tablesRequest);
                tablesResult.getTableList().forEach(table -> tableNames.add(table.getName()));
            } while ((nextToken = tablesResult.getNextToken()) != null);
            return tableNames;
        }
        catch (EntityNotFoundException e) {
            throw new IOException("Failed to get glue tables: " + e.getMessage() + " in Database: " + this.mGlueDbName + "; with Catalog ID: " + this.mGlueConfiguration.get((BaseProperty)Property.CATALOG_ID) + ".", e);
        }
    }

    @VisibleForTesting
    private PathTranslator mountAlluxioPaths(Table table, List<Partition> partitions, UdbBypassSpec bypassSpec) throws IOException {
        String tableName = table.getName();
        AlluxioURI alluxioUri = this.mUdbContext.getTableLocation(tableName);
        String glueUfsUri = table.getStorageDescriptor().getLocation();
        try {
            PathTranslator pathTranslator = new PathTranslator();
            if (bypassSpec.hasFullTable(tableName)) {
                pathTranslator.addMapping(glueUfsUri, glueUfsUri);
                return pathTranslator;
            }
            AlluxioURI ufsUri = new AlluxioURI(table.getStorageDescriptor().getLocation());
            pathTranslator.addMapping(UdbUtils.mountAlluxioPath((String)tableName, (AlluxioURI)ufsUri, (AlluxioURI)alluxioUri, (UdbContext)this.mUdbContext, (UdbConfiguration)this.mGlueConfiguration), glueUfsUri);
            for (Partition partition : partitions) {
                AlluxioURI partitionUri;
                if (partition.getStorageDescriptor() == null || partition.getStorageDescriptor().getLocation() == null || !ufsUri.isAncestorOf(partitionUri = new AlluxioURI(partition.getStorageDescriptor().getLocation()))) continue;
                glueUfsUri = partition.getStorageDescriptor().getLocation();
                String partitionName = partition.getValues().toString();
                try {
                    partitionName = GlueUtils.makePartitionName(table.getPartitionKeys(), partition.getValues());
                }
                catch (IOException e) {
                    LOG.warn("Error making partition name for table {}, partition {} in database {} with CatalogID {}.", new Object[]{tableName, partition.getValues().toString(), this.mGlueDbName, this.mGlueConfiguration.get((BaseProperty)Property.CATALOG_ID)});
                }
                if (bypassSpec.hasPartition(tableName, partitionName)) {
                    pathTranslator.addMapping(partitionUri.getPath(), partitionUri.getPath());
                    continue;
                }
                alluxioUri = new AlluxioURI(PathUtils.concatPath((Object)this.mUdbContext.getTableLocation(tableName).getPath(), (Object)partitionName));
                pathTranslator.addMapping(UdbUtils.mountAlluxioPath((String)tableName, (AlluxioURI)partitionUri, (AlluxioURI)alluxioUri, (UdbContext)this.mUdbContext, (UdbConfiguration)this.mGlueConfiguration), glueUfsUri);
            }
            return pathTranslator;
        }
        catch (AlluxioException e) {
            throw new IOException("Failed to mount table location. tableName: " + tableName + " glueUfsLocation: " + glueUfsUri + " AlluxioLocation: " + alluxioUri + " error: " + e.getMessage(), e);
        }
    }

    private List<ColumnStatisticsInfo> getTableColumnStatistics(String dbName, String tableName, GetColumnStatisticsForTableRequest getColumnStatisticsForTableRequest) {
        try {
            return this.getClient().getColumnStatisticsForTable(getColumnStatisticsForTableRequest).getColumnStatisticsList().stream().map(GlueUtils::toProto).collect(Collectors.toList());
        }
        catch (AmazonClientException e) {
            LOG.warn("Cannot get the table column statistics info for table {}.{} with error {}.", new Object[]{dbName, tableName, e.toString()});
            return Collections.emptyList();
        }
    }

    private List<ColumnStatisticsInfo> getPartitionColumnStatistics(String dbName, String tableName, GetColumnStatisticsForPartitionRequest getColumnStatisticsForPartitionRequest) {
        try {
            List<ColumnStatisticsInfo> partColumnStatistic = this.getClient().getColumnStatisticsForPartition(getColumnStatisticsForPartitionRequest).getColumnStatisticsList().stream().map(GlueUtils::toProto).collect(Collectors.toList());
            return partColumnStatistic;
        }
        catch (AmazonClientException e) {
            LOG.warn("Cannot get the partition column statistics info for table {}.{} with error {}.", new Object[]{dbName, tableName, e.toString()});
            return Collections.emptyList();
        }
    }

    public UdbTable getTable(String tableName, UdbBypassSpec bypassSpec) throws IOException {
        try {
            GetTableRequest tableRequest = new GetTableRequest().withCatalogId(this.mGlueConfiguration.get((BaseProperty)Property.CATALOG_ID)).withDatabaseName(this.mGlueDbName).withName(tableName);
            Table table = this.getClient().getTable(tableRequest).getTable();
            List<Partition> partitions = this.batchGetPartitions(this.getClient(), tableName);
            PathTranslator pathTranslator = this.mountAlluxioPaths(table, partitions, bypassSpec);
            List partitionColumns = table.getPartitionKeys() == null ? Collections.emptyList() : table.getPartitionKeys();
            Map tableParameters = table.getParameters() == null ? Collections.emptyMap() : table.getParameters();
            List columnNames = table.getStorageDescriptor().getColumns().stream().map(Column::getName).collect(Collectors.toList());
            GetColumnStatisticsForTableRequest getColumnStatisticsForTableRequest = new GetColumnStatisticsForTableRequest().withCatalogId(this.mGlueConfiguration.get((BaseProperty)Property.CATALOG_ID)).withDatabaseName(this.mGlueDbName).withTableName(tableName).withColumnNames(columnNames);
            ArrayList<ColumnStatisticsInfo> columnStatisticsTableData = new ArrayList();
            if (this.mGlueConfiguration.getBoolean((BaseProperty)Property.TABLE_COLUMN_STATISTICS_ENABLE)) {
                columnStatisticsTableData = this.getTableColumnStatistics(this.mGlueDbName, tableName, getColumnStatisticsForTableRequest);
            }
            HashMap<String, List<Object>> statsMap = new HashMap<String, List<Object>>();
            if (this.mGlueConfiguration.getBoolean((BaseProperty)Property.PARTITION_COLUMN_STATISTICS_ENABLE)) {
                for (Partition partition : partitions) {
                    List partitionValue = partition.getValues();
                    if (partitionValue == null) continue;
                    GetColumnStatisticsForPartitionRequest getColumnStatisticsForPartitionRequest = new GetColumnStatisticsForPartitionRequest().withCatalogId(this.mGlueConfiguration.get((BaseProperty)Property.CATALOG_ID)).withDatabaseName(this.mGlueDbName).withTableName(tableName).withColumnNames(columnNames).withPartitionValues((Collection)partitionValue);
                    String partName = GlueUtils.makePartitionName(partitionColumns, partition.getValues());
                    statsMap.put(partName, this.getPartitionColumnStatistics(this.mGlueDbName, tableName, getColumnStatisticsForPartitionRequest));
                }
            }
            PartitionInfo partitionInfo = PartitionInfo.newBuilder().setDbName(this.mGlueDbName).setTableName(tableName).addAllDataCols(GlueUtils.toProto(table.getStorageDescriptor().getColumns())).setStorage(GlueUtils.toProto(table.getStorageDescriptor(), pathTranslator)).putAllParameters(tableParameters).build();
            Layout layout = Layout.newBuilder().setLayoutType("hive").setLayoutData(partitionInfo.toByteString()).build();
            ArrayList<UdbPartition> udbPartitions = new ArrayList<UdbPartition>();
            if (partitionColumns.isEmpty()) {
                PartitionInfo.Builder partitionInfoBuilder = PartitionInfo.newBuilder().setDbName(this.mGlueDbName).setTableName(tableName).addAllDataCols(GlueUtils.toProto(table.getStorageDescriptor().getColumns())).setStorage(GlueUtils.toProto(table.getStorageDescriptor(), pathTranslator)).setPartitionName(tableName).putAllParameters(tableParameters);
                udbPartitions.add(new GluePartition(new HiveLayout(partitionInfoBuilder.build(), Collections.emptyList())));
            } else {
                for (Partition partition : partitions) {
                    String partName = GlueUtils.makePartitionName(partitionColumns, partition.getValues());
                    PartitionInfo.Builder partitionInfoBuilder = PartitionInfo.newBuilder().setDbName(this.mGlueDbName).setTableName(tableName).addAllDataCols(GlueUtils.toProto(partition.getStorageDescriptor().getColumns())).setStorage(GlueUtils.toProto(partition.getStorageDescriptor(), pathTranslator)).setPartitionName(partName).putAllParameters(partition.getParameters() == null ? Collections.emptyMap() : partition.getParameters());
                    if (partition.getValues() != null) {
                        partitionInfoBuilder.addAllValues((Iterable)partition.getValues());
                    }
                    udbPartitions.add(new GluePartition(new HiveLayout(partitionInfoBuilder.build(), statsMap.getOrDefault(partName, Collections.emptyList()))));
                }
            }
            return new GlueTable(this, pathTranslator, tableName, GlueUtils.toProtoSchema(table.getStorageDescriptor().getColumns()), columnStatisticsTableData, GlueUtils.toProto(table.getPartitionKeys()), udbPartitions, layout, table);
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("Table " + tableName + " does not exist in Database: " + this.mGlueDbName + "; Catalog ID: " + this.mGlueConfiguration.get((BaseProperty)Property.CATALOG_ID) + ".", (Throwable)e);
        }
        catch (ValidationException e) {
            throw new IOException("Failed to get table: " + tableName + " in Database: " + this.mGlueDbName + "; Catalog ID: " + this.mGlueConfiguration.get((BaseProperty)Property.CATALOG_ID) + " with validation error: " + e.getMessage(), e);
        }
        catch (GlueEncryptionException e) {
            throw new IOException("Failed to get table: " + tableName + " in Database: " + this.mGlueDbName + "; Catalog ID: " + this.mGlueConfiguration.get((BaseProperty)Property.CATALOG_ID) + " error: " + e.getMessage(), e);
        }
    }

    private List<Partition> batchGetPartitions(AWSGlueAsync glueClient, String tableName) throws IOException {
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        String nextToken = null;
        try {
            do {
                GetPartitionsRequest getPartitionsRequest = new GetPartitionsRequest().withCatalogId(this.mGlueConfiguration.get((BaseProperty)Property.CATALOG_ID)).withDatabaseName(this.mGlueDbName).withTableName(tableName).withMaxResults(Integer.valueOf(this.mGlueConfiguration.getInt((BaseProperty)Property.MAX_GLUE_FETCH_PARTITIONS))).withNextToken(nextToken);
                GetPartitionsResult getPartitionsResult = glueClient.getPartitions(getPartitionsRequest);
                partitions.addAll(getPartitionsResult.getPartitions());
                nextToken = getPartitionsResult.getNextToken();
                LOG.debug("Glue table {}.{} adding {} batch partitions with total {} partitions.", new Object[]{this.mGlueDbName, tableName, getPartitionsResult.getPartitions().size(), partitions.size()});
            } while (nextToken != null);
            if (partitions != null) {
                LOG.info("Glue table {}.{} has {} partitions.", new Object[]{this.mGlueDbName, tableName, partitions.size()});
                if (LOG.isDebugEnabled()) {
                    partitions.stream().forEach(partition -> LOG.debug("Glue table {}.{} with partition: {}.", new Object[]{partition.getDatabaseName(), tableName, partition}));
                }
            }
            return partitions;
        }
        catch (AWSGlueException e) {
            throw new IOException("Cannot get partition information for table: " + tableName + " in Database: " + this.mGlueDbName + "; Catalog ID: " + this.mGlueConfiguration.get((BaseProperty)Property.CATALOG_ID) + ". error: " + e.getMessage(), e);
        }
    }

    public AWSGlueAsync getClient() {
        return this.mGlueClient;
    }
}

