/*
 * Decompiled with CFR 0.152.
 */
package alluxio.table.under.glue;

import alluxio.grpc.table.ColumnStatisticsInfo;
import alluxio.grpc.table.FieldSchema;
import alluxio.grpc.table.Layout;
import alluxio.grpc.table.Schema;
import alluxio.table.common.UdbPartition;
import alluxio.table.common.udb.PathTranslator;
import alluxio.table.common.udb.UdbTable;
import alluxio.table.under.glue.GlueDatabase;
import com.amazonaws.services.glue.model.Table;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlueTable
implements UdbTable {
    private static final Logger LOG = LoggerFactory.getLogger(GlueTable.class);
    private final GlueDatabase mGlueDatabase;
    private final PathTranslator mPathTranslator;
    private final String mName;
    private final String mOwner;
    private final Table mTable;
    private final List<FieldSchema> mPartitionKeys;
    private final Map<String, String> mParameters;
    private final List<UdbPartition> mUdbPartitions;
    private final List<ColumnStatisticsInfo> mStatistics;
    private final Schema mSchema;
    private final Layout mLayout;

    public GlueTable(GlueDatabase glueDatabase, PathTranslator pathTranslator, String name, Schema schema, List<ColumnStatisticsInfo> statistics, List<FieldSchema> cols, List<UdbPartition> udbPartitions, Layout layout, Table table) {
        this.mGlueDatabase = glueDatabase;
        this.mPathTranslator = pathTranslator;
        this.mTable = table;
        this.mName = name;
        this.mSchema = schema;
        this.mUdbPartitions = udbPartitions;
        this.mPartitionKeys = cols;
        this.mStatistics = statistics;
        this.mOwner = table.getOwner() != null ? table.getOwner() : null;
        this.mParameters = table.getParameters() != null ? table.getParameters() : Collections.emptyMap();
        this.mLayout = layout;
    }

    public String getName() {
        return this.mName;
    }

    public Schema getSchema() {
        return this.mSchema;
    }

    public String getOwner() {
        return this.mOwner;
    }

    public Map<String, String> getParameters() {
        return this.mParameters;
    }

    public List<FieldSchema> getPartitionCols() {
        return this.mPartitionKeys;
    }

    public List<ColumnStatisticsInfo> getStatistics() {
        return this.mStatistics;
    }

    public Layout getLayout() {
        return this.mLayout;
    }

    public List<UdbPartition> getPartitions() {
        return this.mUdbPartitions;
    }
}

