/*
 * Decompiled with CFR 0.152.
 */
package alluxio.table.under.glue;

import alluxio.grpc.table.BinaryColumnStatsData;
import alluxio.grpc.table.BooleanColumnStatsData;
import alluxio.grpc.table.ColumnStatisticsData;
import alluxio.grpc.table.ColumnStatisticsInfo;
import alluxio.grpc.table.Date;
import alluxio.grpc.table.DateColumnStatsData;
import alluxio.grpc.table.Decimal;
import alluxio.grpc.table.DecimalColumnStatsData;
import alluxio.grpc.table.DoubleColumnStatsData;
import alluxio.grpc.table.FieldSchema;
import alluxio.grpc.table.LongColumnStatsData;
import alluxio.grpc.table.Schema;
import alluxio.grpc.table.StringColumnStatsData;
import alluxio.grpc.table.layout.hive.HiveBucketProperty;
import alluxio.grpc.table.layout.hive.SortingColumn;
import alluxio.grpc.table.layout.hive.Storage;
import alluxio.grpc.table.layout.hive.StorageFormat;
import alluxio.table.common.udb.PathTranslator;
import com.amazonaws.services.glue.model.BinaryColumnStatisticsData;
import com.amazonaws.services.glue.model.BooleanColumnStatisticsData;
import com.amazonaws.services.glue.model.Column;
import com.amazonaws.services.glue.model.ColumnStatistics;
import com.amazonaws.services.glue.model.DateColumnStatisticsData;
import com.amazonaws.services.glue.model.DecimalColumnStatisticsData;
import com.amazonaws.services.glue.model.DoubleColumnStatisticsData;
import com.amazonaws.services.glue.model.LongColumnStatisticsData;
import com.amazonaws.services.glue.model.StorageDescriptor;
import com.amazonaws.services.glue.model.StringColumnStatisticsData;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.common.FileUtils;

public class GlueUtils {
    private GlueUtils() {
    }

    public static Schema toProtoSchema(List<Column> glueColumns) {
        Schema.Builder schemaBuilder = Schema.newBuilder();
        schemaBuilder.addAllCols(GlueUtils.toProto(glueColumns));
        return schemaBuilder.build();
    }

    public static List<FieldSchema> toProto(List<Column> glueCloumns) {
        if (glueCloumns == null) {
            return Collections.emptyList();
        }
        ArrayList<FieldSchema> list = new ArrayList<FieldSchema>();
        for (Column column : glueCloumns) {
            FieldSchema.Builder builder = FieldSchema.newBuilder().setName(column.getName()).setType(column.getType());
            if (column.getComment() != null) {
                builder.setComment(column.getComment());
            }
            list.add(builder.build());
        }
        return list;
    }

    public static ColumnStatisticsInfo toProto(ColumnStatistics glueColumnStatistic) {
        if (glueColumnStatistic == null) {
            return ColumnStatisticsInfo.newBuilder().build();
        }
        ColumnStatisticsInfo.Builder columnStatisticsInfoBuilder = ColumnStatisticsInfo.newBuilder();
        columnStatisticsInfoBuilder.setColName(glueColumnStatistic.getColumnName()).setColType(glueColumnStatistic.getColumnType());
        if (glueColumnStatistic.getStatisticsData() != null) {
            com.amazonaws.services.glue.model.ColumnStatisticsData glueColumnStatisticsData = glueColumnStatistic.getStatisticsData();
            String columnType = glueColumnStatistic.getStatisticsData().getType();
            if (columnType != null) {
                BinaryColumnStatisticsData binaryData;
                StringColumnStatisticsData stringData;
                LongColumnStatisticsData longData;
                DoubleColumnStatisticsData doubleData;
                DecimalColumnStatisticsData decimalData;
                DateColumnStatisticsData dateData;
                BooleanColumnStatisticsData booleanData;
                if (columnType.equals("BOOLEAN") && glueColumnStatisticsData.getBooleanColumnStatisticsData() != null && (booleanData = glueColumnStatisticsData.getBooleanColumnStatisticsData()) != null) {
                    columnStatisticsInfoBuilder.setData(ColumnStatisticsData.newBuilder().setBooleanStats(GlueUtils.toProto(booleanData)).build());
                }
                if (columnType.equals("DATE") && glueColumnStatisticsData.getDateColumnStatisticsData() != null && (dateData = glueColumnStatisticsData.getDateColumnStatisticsData()) != null) {
                    columnStatisticsInfoBuilder.setData(ColumnStatisticsData.newBuilder().setDateStats(GlueUtils.toProto(dateData)).build());
                }
                if (columnType.equals("DECIMAL") && glueColumnStatisticsData.getDecimalColumnStatisticsData() != null && (decimalData = glueColumnStatisticsData.getDecimalColumnStatisticsData()) != null) {
                    columnStatisticsInfoBuilder.setData(ColumnStatisticsData.newBuilder().setDecimalStats(GlueUtils.toProto(decimalData)).build());
                }
                if (columnType.equals("DOUBLE") && glueColumnStatisticsData.getDoubleColumnStatisticsData() != null && (doubleData = glueColumnStatisticsData.getDoubleColumnStatisticsData()) != null) {
                    columnStatisticsInfoBuilder.setData(ColumnStatisticsData.newBuilder().setDoubleStats(GlueUtils.toProto(doubleData)).build());
                }
                if (columnType.equals("LONG") && glueColumnStatisticsData.getLongColumnStatisticsData() != null && (longData = glueColumnStatisticsData.getLongColumnStatisticsData()) != null) {
                    columnStatisticsInfoBuilder.setData(ColumnStatisticsData.newBuilder().setLongStats(GlueUtils.toProto(longData)).build());
                }
                if (columnType.equals("STRING") && glueColumnStatisticsData.getStringColumnStatisticsData() != null && (stringData = glueColumnStatisticsData.getStringColumnStatisticsData()) != null) {
                    columnStatisticsInfoBuilder.setData(ColumnStatisticsData.newBuilder().setStringStats(GlueUtils.toProto(stringData)).build());
                }
                if (columnType.equals("BINARY") && glueColumnStatisticsData.getBinaryColumnStatisticsData() != null && (binaryData = glueColumnStatisticsData.getBinaryColumnStatisticsData()) != null) {
                    columnStatisticsInfoBuilder.setData(ColumnStatisticsData.newBuilder().setBinaryStats(GlueUtils.toProto(binaryData)).build());
                }
            }
        }
        return columnStatisticsInfoBuilder.build();
    }

    private static BooleanColumnStatsData toProto(BooleanColumnStatisticsData booleanData) {
        BooleanColumnStatsData.Builder builder = BooleanColumnStatsData.newBuilder();
        builder.setNumNulls(booleanData.getNumberOfNulls().longValue()).setNumTrues(booleanData.getNumberOfTrues().longValue()).setNumFalses(booleanData.getNumberOfFalses().longValue());
        return builder.build();
    }

    private static DateColumnStatsData toProto(DateColumnStatisticsData dateData) {
        DateColumnStatsData.Builder builder = DateColumnStatsData.newBuilder();
        builder.setNumNulls(dateData.getNumberOfNulls().longValue()).setNumDistincts(dateData.getNumberOfDistinctValues().longValue());
        if (dateData.getMaximumValue() != null) {
            builder.setHighValue(Date.newBuilder().setDaysSinceEpoch(dateData.getMaximumValue().getTime()).build());
        }
        if (dateData.getMinimumValue() != null) {
            builder.setLowValue(Date.newBuilder().setDaysSinceEpoch(dateData.getMinimumValue().getTime()).build());
        }
        return builder.build();
    }

    private static DecimalColumnStatsData toProto(DecimalColumnStatisticsData decimalData) {
        DecimalColumnStatsData.Builder builder = DecimalColumnStatsData.newBuilder();
        builder.setNumNulls(decimalData.getNumberOfNulls().longValue()).setNumDistincts(decimalData.getNumberOfDistinctValues().longValue());
        if (decimalData.getMaximumValue() != null) {
            builder.setHighValue(Decimal.newBuilder().setScale(decimalData.getMaximumValue().getScale().intValue()).setUnscaled(ByteString.copyFrom((byte[])decimalData.getMaximumValue().getUnscaledValue().array())));
        }
        if (decimalData.getMinimumValue() != null) {
            builder.setLowValue(Decimal.newBuilder().setScale(decimalData.getMinimumValue().getScale().intValue()).setUnscaled(ByteString.copyFrom((byte[])decimalData.getMinimumValue().getUnscaledValue().array())));
        }
        return builder.build();
    }

    private static DoubleColumnStatsData toProto(DoubleColumnStatisticsData doubleData) {
        DoubleColumnStatsData.Builder builder = DoubleColumnStatsData.newBuilder();
        builder.setNumNulls(doubleData.getNumberOfNulls().longValue()).setNumDistincts(doubleData.getNumberOfDistinctValues().longValue());
        if (doubleData.getMaximumValue() != null) {
            builder.setHighValue(doubleData.getMaximumValue().doubleValue());
        }
        if (doubleData.getMinimumValue() != null) {
            builder.setLowValue(doubleData.getMinimumValue().doubleValue());
        }
        return builder.build();
    }

    private static LongColumnStatsData toProto(LongColumnStatisticsData longData) {
        LongColumnStatsData.Builder builder = LongColumnStatsData.newBuilder();
        builder.setNumNulls(longData.getNumberOfNulls().longValue()).setNumDistincts(longData.getNumberOfDistinctValues().longValue());
        if (longData.getMaximumValue() != null) {
            builder.setHighValue(longData.getMaximumValue().longValue());
        }
        if (longData.getMinimumValue() != null) {
            builder.setLowValue(longData.getMinimumValue().longValue());
        }
        return builder.build();
    }

    private static StringColumnStatsData toProto(StringColumnStatisticsData stringData) {
        StringColumnStatsData.Builder builder = StringColumnStatsData.newBuilder();
        builder.setNumNulls(stringData.getNumberOfNulls().longValue()).setNumDistincts(stringData.getNumberOfDistinctValues().longValue());
        if (stringData.getAverageLength() != null) {
            builder.setAvgColLen(stringData.getAverageLength().doubleValue());
        }
        if (stringData.getMaximumLength() != null) {
            builder.setMaxColLen(stringData.getMaximumLength().longValue());
        }
        return builder.build();
    }

    private static BinaryColumnStatsData toProto(BinaryColumnStatisticsData binaryData) {
        BinaryColumnStatsData.Builder builder = BinaryColumnStatsData.newBuilder();
        builder.setNumNulls(binaryData.getNumberOfNulls().longValue());
        if (binaryData.getMaximumLength() != null) {
            builder.setMaxColLen(binaryData.getMaximumLength().longValue());
        }
        if (binaryData.getAverageLength() != null) {
            builder.setAvgColLen(binaryData.getAverageLength().doubleValue());
        }
        return builder.build();
    }

    public static Storage toProto(StorageDescriptor sd, PathTranslator translator) throws IOException {
        if (sd == null) {
            return Storage.getDefaultInstance();
        }
        String serDe = sd.getSerdeInfo() == null ? null : sd.getSerdeInfo().getSerializationLibrary();
        Map serdeLibMap = sd.getSerdeInfo() == null ? null : sd.getSerdeInfo().getParameters();
        StorageFormat.Builder formatBuilder = StorageFormat.newBuilder().setInputFormat(sd.getInputFormat()).setOutputFormat(sd.getOutputFormat());
        if (serdeLibMap != null) {
            formatBuilder.putAllSerdelibParameters(serdeLibMap);
        }
        if (serDe != null) {
            formatBuilder.setSerde(serDe);
        }
        Storage.Builder storageBuilder = Storage.newBuilder();
        List bucketColumn = sd.getBucketColumns() == null ? Collections.emptyList() : sd.getBucketColumns();
        List orderList = sd.getSortColumns();
        List sortingColumns = orderList == null ? Collections.emptyList() : orderList.stream().map(order -> SortingColumn.newBuilder().setColumnName(order.getColumn()).setOrder(order.getSortOrder() == 1 ? SortingColumn.SortingOrder.ASCENDING : SortingColumn.SortingOrder.DESCENDING).build()).collect(Collectors.toList());
        return storageBuilder.setStorageFormat(formatBuilder.build()).setLocation(translator.toAlluxioPath(sd.getLocation())).setBucketProperty(HiveBucketProperty.newBuilder().setBucketCount((long)sd.getNumberOfBuckets().intValue()).addAllBucketedBy((Iterable)bucketColumn).addAllSortedBy(sortingColumns).build()).setSkewed(sd.getSkewedInfo() != null && sd.getSkewedInfo().getSkewedColumnNames() != null && !sd.getSkewedInfo().getSkewedColumnNames().isEmpty()).putAllSerdeParameters(sd.getParameters()).build();
    }

    public static String makePartitionName(List<Column> columns, List<String> partitionValues) throws IOException {
        if (columns.size() != partitionValues.size() || columns.size() == 0) {
            Object errorMesg = "Invalid partition key & values; key [";
            for (Column column : columns) {
                errorMesg = (String)errorMesg + column.getName() + ",";
            }
            errorMesg = (String)errorMesg + "], values [";
            for (String partitionValue : partitionValues) {
                errorMesg = (String)errorMesg + partitionValue + ", ";
            }
            throw new IOException((String)errorMesg + "]");
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        for (Column column : columns) {
            columnNames.add(column.getName());
        }
        return GlueUtils.makePartName(columnNames, partitionValues);
    }

    public static String makePartName(List<String> partCols, List<String> vals) {
        return FileUtils.makePartName(partCols, vals);
    }
}

