/*
 * Decompiled with CFR 0.152.
 */
package alluxio.table.under.glue;

import alluxio.table.common.udb.UdbProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Property
extends UdbProperty {
    private static final Logger LOG = LoggerFactory.getLogger(Property.class);
    private static final Map<String, Property> DEFAULT_KEYS_MAP = new ConcurrentHashMap<String, Property>();
    public static final Property MAX_GLUE_CONNECTION = new Builder("max.connection").setDefaultValue("5").setDescription("The maximum number of connection to glue metastore.").build();
    public static final Property MAX_GLUE_FETCH_PARTITIONS = new Builder("partitions.fetch.max").setDefaultValue("512").setDescription("The maximum number of partitions to return in a single response.").build();
    public static final Property GLUE_REGION = new Builder("aws.region").setDefaultValue("").setDescription("The regional endpoint for client service calls.").build();
    public static final Property CATALOG_ID = new Builder("aws.catalog.id").setDefaultValue("").setDescription("The catalog id of aws glue.").build();
    public static final Property AWS_GLUE_ACCESS_KEY = new Builder("aws.accesskey").setDefaultValue("").setDescription("The access key to access the aws glue.").build();
    public static final Property AWS_GLUE_SECRET_KEY = new Builder("aws.secretkey").setDefaultValue("").setDescription("The secret key to access the aws glue.").build();
    public static final Property AWS_PROXY_PROTOCOL = new Builder("aws.proxy.protocol").setDefaultValue("HTTP").setDescription("The Protocol to use for connecting to the proxy.").build();
    public static final Property AWS_PROXY_HOST = new Builder("aws.proxy.host").setDefaultValue("").setDescription("The proxy host the client will connect through.").build();
    public static final Property AWS_PROXY_PORT = new Builder("aws.proxy.port").setDefaultValue("").setDescription("The proxy port the client will connect through.").build();
    public static final Property AWS_PROXY_USER_NAME = new Builder("aws.proxy.username").setDefaultValue("").setDescription("The proxy user name.").build();
    public static final Property AWS_PROXY_PASSWORD = new Builder("aws.proxy.password").setDefaultValue("").setDescription("The proxy password.").build();
    public static final Property TABLE_COLUMN_STATISTICS_ENABLE = new Builder("table.column.statistics").setDefaultValue("false").setDescription("Enable Glue table column statistics.").build();
    public static final Property PARTITION_COLUMN_STATISTICS_ENABLE = new Builder("partition.column.statistics").setDefaultValue("false").setDescription("Enable Glue partition column statistics.").build();

    public Property(String name, String description, String defaultValue) {
        super(name, description, defaultValue);
    }

    @VisibleForTesting
    public static boolean register(Property Property2) {
        String name = Property2.getName();
        if (DEFAULT_KEYS_MAP.containsKey(name)) {
            return false;
        }
        DEFAULT_KEYS_MAP.put(name, Property2);
        return true;
    }

    @VisibleForTesting
    public static void unregister(Property Property2) {
        String name = Property2.getName();
        DEFAULT_KEYS_MAP.remove(name);
    }

    public String getName() {
        return this.mName;
    }

    public String getDescription() {
        return this.mDescription;
    }

    @Nullable
    public String getDefaultValue() {
        String defaultValue = this.mDefaultValue;
        return defaultValue == null ? null : defaultValue.toString();
    }

    public static final class Name {
        public static final String MAX_GLUE_CONNECTION = "max.connection";
        public static final String MAX_GLUE_FETCH_PARTITIONS = "partitions.fetch.max";
        public static final String GLUE_REGION = "aws.region";
        public static final String CATALOG_ID = "aws.catalog.id";
        public static final String AWS_GLUE_ACCESS_KEY = "aws.accesskey";
        public static final String AWS_GLUE_SECRET_KEY = "aws.secretkey";
        public static final String AWS_PROXY_PROTOCOL = "aws.proxy.protocol";
        public static final String AWS_PROXY_HOST = "aws.proxy.host";
        public static final String AWS_PROXY_PORT = "aws.proxy.port";
        public static final String AWS_PROXY_USER_NAME = "aws.proxy.username";
        public static final String AWS_PROXY_PASSWORD = "aws.proxy.password";
        public static final String TABLE_COLUMN_STATISTICS_ENABLE = "table.column.statistics";
        public static final String PARTITION_COLUMN_STATISTICS_ENABLE = "partition.column.statistics";
    }

    public static final class Builder {
        private String mName;
        private String mDescription;
        private String mDefaultValue;

        public Builder(String name) {
            this.mName = name;
        }

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder setDefaultValue(String defaultValue) {
            this.mDefaultValue = defaultValue;
            return this;
        }

        public Builder setDescription(String description) {
            this.mDescription = description;
            return this;
        }

        public Property build() {
            Property property = this.buildUnregistered();
            Preconditions.checkState((boolean)Property.register(property), (String)"Cannot register existing alluxio.table.under.glue.Property \"%s\"", (Object)this.mName);
            return property;
        }

        public Property buildUnregistered() {
            Property property = new Property(this.mName, this.mDescription, this.mDefaultValue);
            return property;
        }
    }
}

