/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.table.command;

import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.table.TableShellUtils;
import alluxio.cli.table.command.AbstractTableCommand;
import alluxio.client.table.TableMasterClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.grpc.table.SyncStatus;
import org.apache.commons.cli.CommandLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncDatabaseCommand
extends AbstractTableCommand {
    private static final Logger LOG = LoggerFactory.getLogger(SyncDatabaseCommand.class);
    private static final int PRINT_MAX_ERRORS = 10;

    public SyncDatabaseCommand(AlluxioConfiguration conf, TableMasterClient client) {
        super(conf, client);
    }

    @Override
    public void validateArgs(CommandLine cli) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cli, (int)1);
    }

    @Override
    public String getCommandName() {
        return "sync";
    }

    public String getUsage() {
        return "sync <db name>";
    }

    public String getDescription() {
        return "Sync a database with the given name with the UDB";
    }

    @Override
    public int run(CommandLine cli) throws AlluxioStatusException {
        SyncStatus status = this.mClient.syncDatabase(cli.getArgs()[0]);
        TableShellUtils.printSyncStatus(status, LOG, 10);
        return 0;
    }
}

