/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.hdfs;

import alluxio.exception.runtime.AlluxioRuntimeException;
import alluxio.grpc.ErrorType;
import com.google.protobuf.Any;
import com.sun.jersey.api.ParamException;
import com.sun.jersey.api.container.ContainerException;
import io.grpc.Status;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.token.SecretManager;

public class AlluxioHdfsException
extends AlluxioRuntimeException {
    public static AlluxioHdfsException fromUfsException(Exception e) {
        if ((e = AlluxioHdfsException.convertException(e)) instanceof SecurityException) {
            return new AlluxioHdfsException(Status.PERMISSION_DENIED, e.getMessage(), e, ErrorType.User, false);
        }
        if (e instanceof AuthorizationException) {
            return new AlluxioHdfsException(Status.UNAUTHENTICATED, e.getMessage(), e, ErrorType.User, false);
        }
        if (e instanceof FileNotFoundException) {
            return new AlluxioHdfsException(Status.NOT_FOUND, e.getMessage(), e, ErrorType.User, false);
        }
        if (e instanceof UnsupportedOperationException) {
            return new AlluxioHdfsException(Status.UNIMPLEMENTED, e.getMessage(), e, ErrorType.User, false);
        }
        if (e instanceof IllegalArgumentException) {
            return new AlluxioHdfsException(Status.INVALID_ARGUMENT, e.getMessage(), e, ErrorType.User, false);
        }
        if (e instanceof IOException) {
            return new AlluxioHdfsException(Status.ABORTED, e.getMessage(), e, ErrorType.External, true);
        }
        return new AlluxioHdfsException(Status.UNKNOWN, e.getMessage(), e, ErrorType.External, false);
    }

    AlluxioHdfsException(Status status, String message, Throwable cause, ErrorType errorType, boolean retryable) {
        super(status, message, cause, errorType, retryable, new Any[0]);
    }

    private static Exception convertException(Exception e) {
        if (e instanceof ParamException) {
            ParamException paramexception = (ParamException)e;
            e = new IllegalArgumentException("Invalid value for hdfs parameter \"" + paramexception.getParameterName() + "\": " + e.getCause().getMessage(), e);
        }
        if (e instanceof ContainerException) {
            e = AlluxioHdfsException.toCause(e);
        }
        if (e instanceof RemoteException) {
            e = ((RemoteException)e).unwrapRemoteException();
        }
        if (e instanceof SecurityException) {
            e = AlluxioHdfsException.toCause(e);
        }
        return e;
    }

    private static Exception toCause(Exception e) {
        Throwable t = e.getCause();
        if (e instanceof SecurityException) {
            Throwable t1;
            if (t instanceof SecretManager.InvalidToken && (t1 = t.getCause()) instanceof StandbyException) {
                e = (StandbyException)t1;
            }
        } else if (t instanceof Exception) {
            e = (Exception)t;
        }
        return e;
    }
}

