/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.hdfs;

import alluxio.AlluxioURI;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.UnderFileSystemFactory;
import alluxio.underfs.hdfs.HdfsUnderFileSystem;
import alluxio.underfs.hdfs.HdfsVersion;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class HdfsUnderFileSystemFactory
implements UnderFileSystemFactory {
    public UnderFileSystem create(String path, UnderFileSystemConfiguration conf) {
        Preconditions.checkNotNull((Object)path, (Object)"path");
        return HdfsUnderFileSystem.createInstance(new AlluxioURI(path), conf);
    }

    public boolean supportsPath(String path) {
        if (path != null) {
            for (String prefix : Configuration.global().getList(PropertyKey.UNDERFS_HDFS_PREFIXES)) {
                if (!path.startsWith(prefix)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean supportsPath(String path, UnderFileSystemConfiguration conf) {
        if (path != null) {
            AlluxioConfiguration alluxioConf = Configuration.global();
            for (String prefix : alluxioConf.getList(PropertyKey.UNDERFS_HDFS_PREFIXES)) {
                if (!path.startsWith(prefix) || conf.isSetByUser(PropertyKey.UNDERFS_VERSION) && !HdfsVersion.matches(conf.getString(PropertyKey.UNDERFS_VERSION), this.getVersion())) continue;
                return true;
            }
        }
        return false;
    }

    public String getVersion() {
        return "3.3.1";
    }
}

