/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.local;

import alluxio.AlluxioURI;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.UnderFileSystemFactory;
import alluxio.underfs.local.LocalUnderFileSystem;
import alluxio.util.URIUtils;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class LocalUnderFileSystemFactory
implements UnderFileSystemFactory {
    public UnderFileSystem create(String path, UnderFileSystemConfiguration conf) {
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"path may not be null");
        return new LocalUnderFileSystem(new AlluxioURI(path), conf);
    }

    public boolean supportsPath(String path) {
        if (path == null) {
            return false;
        }
        return URIUtils.isLocalFilesystem((String)path);
    }
}

