/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.s3;

import alluxio.AlluxioURI;
import alluxio.PropertyKey;
import alluxio.underfs.ObjectUnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.options.OpenOptions;
import alluxio.underfs.s3.S3InputStream;
import alluxio.underfs.s3.S3OutputStream;
import alluxio.underfs.s3.S3Utils;
import alluxio.underfs.s3.org.jets3t.service.Jets3tProperties;
import alluxio.underfs.s3.org.jets3t.service.S3Service;
import alluxio.underfs.s3.org.jets3t.service.ServiceException;
import alluxio.underfs.s3.org.jets3t.service.StorageObjectsChunk;
import alluxio.underfs.s3.org.jets3t.service.acl.AccessControlList;
import alluxio.underfs.s3.org.jets3t.service.impl.rest.httpclient.RestS3Service;
import alluxio.underfs.s3.org.jets3t.service.model.S3Object;
import alluxio.underfs.s3.org.jets3t.service.model.StorageObject;
import alluxio.underfs.s3.org.jets3t.service.security.AWSCredentials;
import alluxio.util.CommonUtils;
import alluxio.util.UnderFileSystemUtils;
import alluxio.util.io.PathUtils;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class S3UnderFileSystem
extends ObjectUnderFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(S3UnderFileSystem.class);
    private static final String FOLDER_SUFFIX = "_$folder$";
    private static final byte[] DIR_HASH;
    private final S3Service mClient;
    private final String mBucketName;
    private final String mAccountOwner;
    private final short mBucketMode;

    public static S3UnderFileSystem createInstance(AlluxioURI uri, UnderFileSystemConfiguration conf) throws ServiceException {
        String bucketName = UnderFileSystemUtils.getBucketName((AlluxioURI)uri);
        Preconditions.checkArgument((boolean)conf.containsKey(PropertyKey.S3N_ACCESS_KEY), (Object)("Property " + PropertyKey.S3N_ACCESS_KEY + " is required to connect to S3"));
        Preconditions.checkArgument((boolean)conf.containsKey(PropertyKey.S3N_SECRET_KEY), (Object)("Property " + PropertyKey.S3N_SECRET_KEY + " is required to connect to S3"));
        AWSCredentials awsCredentials = new AWSCredentials(conf.getValue(PropertyKey.S3N_ACCESS_KEY), conf.getValue(PropertyKey.S3N_SECRET_KEY));
        Jets3tProperties props = new Jets3tProperties();
        if (conf.containsKey(PropertyKey.UNDERFS_S3_PROXY_HOST)) {
            props.setProperty("httpclient.proxy-autodetect", "false");
            props.setProperty("httpclient.proxy-host", conf.getValue(PropertyKey.UNDERFS_S3_PROXY_HOST));
            props.setProperty("httpclient.proxy-port", conf.getValue(PropertyKey.UNDERFS_S3_PROXY_PORT));
        }
        if (conf.containsKey(PropertyKey.UNDERFS_S3_PROXY_HTTPS_ONLY)) {
            props.setProperty("s3service.https-only", conf.getValue(PropertyKey.UNDERFS_S3_PROXY_HTTPS_ONLY));
        }
        if (conf.containsKey(PropertyKey.UNDERFS_S3_ENDPOINT)) {
            props.setProperty("s3service.s3-endpoint", conf.getValue(PropertyKey.UNDERFS_S3_ENDPOINT));
            if (conf.containsKey(PropertyKey.UNDERFS_S3_PROXY_HTTPS_ONLY)) {
                props.setProperty("s3service.s3-endpoint-https-port", conf.getValue(PropertyKey.UNDERFS_S3_ENDPOINT_HTTPS_PORT));
            } else {
                props.setProperty("s3service.s3-endpoint-http-port", conf.getValue(PropertyKey.UNDERFS_S3_ENDPOINT_HTTP_PORT));
            }
        }
        if (conf.containsKey(PropertyKey.UNDERFS_S3_DISABLE_DNS_BUCKETS)) {
            props.setProperty("s3service.disable-dns-buckets", conf.getValue(PropertyKey.UNDERFS_S3_DISABLE_DNS_BUCKETS));
        }
        if (conf.containsKey(PropertyKey.UNDERFS_S3_UPLOAD_THREADS_MAX)) {
            props.setProperty("threaded-service.max-thread-count", conf.getValue(PropertyKey.UNDERFS_S3_UPLOAD_THREADS_MAX));
        }
        if (conf.containsKey(PropertyKey.UNDERFS_S3_ADMIN_THREADS_MAX)) {
            props.setProperty("threaded-service.admin-max-thread-count", conf.getValue(PropertyKey.UNDERFS_S3_ADMIN_THREADS_MAX));
        }
        if (conf.containsKey(PropertyKey.UNDERFS_S3_THREADS_MAX)) {
            props.setProperty("httpclient.max-connections", conf.getValue(PropertyKey.UNDERFS_S3_THREADS_MAX));
        }
        LOG.debug("Initializing S3 underFs with properties: {}", (Object)props.getProperties());
        RestS3Service restS3Service = new RestS3Service(awsCredentials, null, null, props);
        String accountOwnerId = restS3Service.getAccountOwner().getId();
        String owner = CommonUtils.getValueFromStaticMapping((String)conf.getValue(PropertyKey.UNDERFS_S3_OWNER_ID_TO_USERNAME_MAPPING), (String)accountOwnerId);
        if (owner == null) {
            owner = restS3Service.getAccountOwner().getDisplayName();
        }
        String accountOwner = owner == null ? accountOwnerId : owner;
        AccessControlList acl = restS3Service.getBucketAcl(bucketName);
        short bucketMode = S3Utils.translateBucketAcl(acl, accountOwnerId);
        return new S3UnderFileSystem(uri, restS3Service, bucketName, bucketMode, accountOwner, conf);
    }

    protected S3UnderFileSystem(AlluxioURI uri, S3Service s3Service, String bucketName, short bucketMode, String accountOwner, UnderFileSystemConfiguration conf) {
        super(uri, conf);
        this.mClient = s3Service;
        this.mBucketName = bucketName;
        this.mBucketMode = bucketMode;
        this.mAccountOwner = accountOwner;
    }

    public String getUnderFSType() {
        return "s3";
    }

    public void setOwner(String path, String user, String group) {
    }

    public void setMode(String path, short mode) throws IOException {
    }

    protected boolean copyObject(String src, String dst) {
        LOG.debug("Copying {} to {}", (Object)src, (Object)dst);
        S3Object obj = new S3Object(dst);
        int retries = 3;
        for (int i = 0; i < retries; ++i) {
            try {
                this.mClient.copyObject(this.mBucketName, src, this.mBucketName, obj, false);
                return true;
            }
            catch (ServiceException e) {
                LOG.error("Failed to copy file {} to {}", new Object[]{src, dst, e});
                if (i == retries - 1) continue;
                LOG.error("Retrying copying file {} to {}", (Object)src, (Object)dst);
                continue;
            }
        }
        LOG.error("Failed to copy file {} to {}, after {} retries", new Object[]{src, dst, retries});
        return false;
    }

    protected boolean createEmptyObject(String key) {
        try {
            S3Object obj = new S3Object(key);
            obj.setDataInputStream(new ByteArrayInputStream(new byte[0]));
            obj.setContentLength(0L);
            obj.setMd5Hash(DIR_HASH);
            obj.setContentType("binary/octet-stream");
            this.mClient.putObject(this.mBucketName, obj);
            return true;
        }
        catch (ServiceException e) {
            LOG.error("Failed to create object: {}", (Object)key, (Object)e);
            return false;
        }
    }

    protected OutputStream createObject(String key) throws IOException {
        return new S3OutputStream(this.mBucketName, key, this.mClient);
    }

    protected boolean deleteObject(String key) {
        try {
            this.mClient.deleteObject(this.mBucketName, key);
        }
        catch (ServiceException e) {
            LOG.error("Failed to delete {}", (Object)key, (Object)e);
            return false;
        }
        return true;
    }

    protected String getFolderSuffix() {
        return FOLDER_SUFFIX;
    }

    protected ObjectUnderFileSystem.ObjectListingChunk getObjectListingChunk(String key, boolean recursive) throws IOException {
        String delimiter;
        StorageObjectsChunk chunk = this.getObjectListingChunk(key = (key = PathUtils.normalizePath((String)key, (String)PATH_SEPARATOR)).equals(PATH_SEPARATOR) ? "" : key, delimiter = recursive ? "" : PATH_SEPARATOR, null);
        if (chunk != null) {
            return new S3NObjectListingChunk(chunk);
        }
        return null;
    }

    private StorageObjectsChunk getObjectListingChunk(String key, String delimiter, String priorLastKey) {
        StorageObjectsChunk res;
        try {
            res = this.mClient.listObjectsChunked(this.mBucketName, key, delimiter, this.getListingChunkLength(), priorLastKey);
        }
        catch (ServiceException e) {
            LOG.error("Failed to list path {}", (Object)key, (Object)e);
            res = null;
        }
        return res;
    }

    protected ObjectUnderFileSystem.ObjectStatus getObjectStatus(String key) {
        try {
            StorageObject meta = this.mClient.getObjectDetails(this.mBucketName, key);
            if (meta == null) {
                return null;
            }
            return new ObjectUnderFileSystem.ObjectStatus((ObjectUnderFileSystem)this, key, meta.getContentLength(), meta.getLastModifiedDate().getTime());
        }
        catch (ServiceException e) {
            return null;
        }
    }

    protected ObjectUnderFileSystem.ObjectPermissions getPermissions() {
        return new ObjectUnderFileSystem.ObjectPermissions((ObjectUnderFileSystem)this, this.mAccountOwner, this.mAccountOwner, this.mBucketMode);
    }

    protected String getRootKey() {
        return "s3n://" + this.mBucketName;
    }

    protected InputStream openObject(String key, OpenOptions options) throws IOException {
        try {
            return new S3InputStream(this.mBucketName, key, this.mClient, options.getOffset());
        }
        catch (ServiceException e) {
            throw new IOException(e.getMessage());
        }
    }

    static {
        try {
            DIR_HASH = MessageDigest.getInstance("MD5").digest(new byte[0]);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    private final class S3NObjectListingChunk
    implements ObjectUnderFileSystem.ObjectListingChunk {
        final StorageObjectsChunk mChunk;

        S3NObjectListingChunk(StorageObjectsChunk chunk) throws IOException {
            this.mChunk = chunk;
            if (this.mChunk == null) {
                throw new IOException("S3N listing result is null");
            }
        }

        public ObjectUnderFileSystem.ObjectStatus[] getObjectStatuses() {
            StorageObject[] objects = this.mChunk.getObjects();
            ObjectUnderFileSystem.ObjectStatus[] ret = new ObjectUnderFileSystem.ObjectStatus[objects.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = new ObjectUnderFileSystem.ObjectStatus((ObjectUnderFileSystem)S3UnderFileSystem.this, objects[i].getKey(), objects[i].getContentLength(), objects[i].getLastModifiedDate().getTime());
            }
            return ret;
        }

        public String[] getCommonPrefixes() {
            return this.mChunk.getCommonPrefixes();
        }

        public ObjectUnderFileSystem.ObjectListingChunk getNextChunk() throws IOException {
            StorageObjectsChunk nextChunk;
            if (!this.mChunk.isListingComplete() && (nextChunk = S3UnderFileSystem.this.getObjectListingChunk(this.mChunk.getPrefix(), this.mChunk.getDelimiter(), this.mChunk.getPriorLastKey())) != null) {
                return new S3NObjectListingChunk(nextChunk);
            }
            return null;
        }
    }
}

