/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.s3;

import alluxio.AlluxioURI;
import alluxio.PropertyKey;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.UnderFileSystemFactory;
import alluxio.underfs.s3.S3UnderFileSystem;
import alluxio.underfs.s3.org.jets3t.service.ServiceException;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class S3UnderFileSystemFactory
implements UnderFileSystemFactory {
    public UnderFileSystem create(String path, UnderFileSystemConfiguration conf) {
        Preconditions.checkNotNull((Object)path, (Object)"path");
        if (this.checkAWSCredentials(conf)) {
            try {
                return S3UnderFileSystem.createInstance(new AlluxioURI(path), conf);
            }
            catch (ServiceException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        String err = "AWS Credentials not available, cannot create S3 Under File System.";
        throw Throwables.propagate((Throwable)new IOException(err));
    }

    public boolean supportsPath(String path) {
        return path != null && path.startsWith("s3n://");
    }

    private boolean checkAWSCredentials(UnderFileSystemConfiguration conf) {
        return conf.containsKey(PropertyKey.S3N_ACCESS_KEY) && conf.containsKey(PropertyKey.S3N_SECRET_KEY);
    }
}

