/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.s3;

import alluxio.underfs.s3.org.jets3t.service.acl.AccessControlList;
import alluxio.underfs.s3.org.jets3t.service.acl.GrantAndPermission;
import alluxio.underfs.s3.org.jets3t.service.acl.GranteeInterface;
import alluxio.underfs.s3.org.jets3t.service.acl.GroupGrantee;
import alluxio.underfs.s3.org.jets3t.service.acl.Permission;

public final class S3Utils {
    public static short translateBucketAcl(AccessControlList acl, String userId) {
        short mode = 0;
        for (GrantAndPermission gp : acl.getGrantAndPermissions()) {
            Permission perm = gp.getPermission();
            GranteeInterface grantee = gp.getGrantee();
            if (perm.equals(Permission.PERMISSION_READ)) {
                if (!S3Utils.isUserIdInGrantee(grantee, userId)) continue;
                mode = (short)(mode | 0x140);
                continue;
            }
            if (perm.equals(Permission.PERMISSION_WRITE)) {
                if (!S3Utils.isUserIdInGrantee(grantee, userId)) continue;
                mode = (short)(mode | 0x80);
                continue;
            }
            if (!perm.equals(Permission.PERMISSION_FULL_CONTROL) || !S3Utils.isUserIdInGrantee(grantee, userId)) continue;
            mode = (short)(mode | 0x1C0);
        }
        return mode;
    }

    private static boolean isUserIdInGrantee(GranteeInterface grantee, String userId) {
        return grantee.getIdentifier().equals(userId) || grantee.equals(GroupGrantee.ALL_USERS) || grantee.equals(GroupGrantee.AUTHENTICATED_USERS);
    }

    private S3Utils() {
    }
}

