/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.s3.org.jets3t.service.impl.rest;

import alluxio.underfs.s3.org.jets3t.service.acl.AccessControlList;
import alluxio.underfs.s3.org.jets3t.service.acl.CanonicalGrantee;
import alluxio.underfs.s3.org.jets3t.service.acl.EmailAddressGrantee;
import alluxio.underfs.s3.org.jets3t.service.acl.GranteeInterface;
import alluxio.underfs.s3.org.jets3t.service.acl.GroupGrantee;
import alluxio.underfs.s3.org.jets3t.service.acl.Permission;
import alluxio.underfs.s3.org.jets3t.service.impl.rest.DefaultXmlHandler;
import alluxio.underfs.s3.org.jets3t.service.model.S3Owner;
import alluxio.underfs.s3.org.jets3t.service.model.StorageOwner;

public class AccessControlListHandler
extends DefaultXmlHandler {
    protected AccessControlList accessControlList = null;
    protected StorageOwner owner = null;
    protected GranteeInterface currentGrantee = null;
    protected Permission currentPermission = null;
    protected boolean insideACL = false;

    public AccessControlList getAccessControlList() {
        return this.accessControlList;
    }

    public void startElement(String name) {
        if (name.equals("Owner")) {
            this.owner = new S3Owner();
        } else if (name.equals("AccessControlList")) {
            this.accessControlList = new AccessControlList();
            this.accessControlList.setOwner(this.owner);
            this.insideACL = true;
        }
    }

    public void endElement(String name, String elementText) {
        if (name.equals("ID") && !this.insideACL) {
            this.owner.setId(elementText);
        } else if (name.equals("DisplayName") && !this.insideACL) {
            this.owner.setDisplayName(elementText);
        } else if (name.equals("ID")) {
            this.currentGrantee = new CanonicalGrantee();
            this.currentGrantee.setIdentifier(elementText);
        } else if (name.equals("EmailAddress")) {
            this.currentGrantee = new EmailAddressGrantee();
            this.currentGrantee.setIdentifier(elementText);
        } else if (name.equals("URI")) {
            this.currentGrantee = new GroupGrantee();
            this.currentGrantee.setIdentifier(elementText);
        } else if (name.equals("DisplayName")) {
            if (this.currentGrantee instanceof CanonicalGrantee) {
                ((CanonicalGrantee)this.currentGrantee).setDisplayName(elementText);
            }
        } else if (name.equals("Permission")) {
            this.currentPermission = Permission.parsePermission(elementText);
        } else if (name.equals("Grant")) {
            this.accessControlList.grantPermission(this.currentGrantee, this.currentPermission);
        } else if (name.equals("AccessControlList")) {
            this.insideACL = false;
        }
    }
}

