/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.s3.org.jets3t.service.multi.event;

import alluxio.underfs.s3.org.jets3t.service.model.StorageObject;
import alluxio.underfs.s3.org.jets3t.service.multi.ThreadWatcher;
import alluxio.underfs.s3.org.jets3t.service.multi.event.ServiceEvent;

public class DeleteObjectsEvent
extends ServiceEvent {
    private StorageObject[] objects = null;

    private DeleteObjectsEvent(int eventCode, Object uniqueOperationId) {
        super(eventCode, uniqueOperationId);
    }

    public static DeleteObjectsEvent newErrorEvent(Throwable t, Object uniqueOperationId) {
        DeleteObjectsEvent event = new DeleteObjectsEvent(0, uniqueOperationId);
        event.setErrorCause(t);
        return event;
    }

    public static DeleteObjectsEvent newStartedEvent(ThreadWatcher threadWatcher, Object uniqueOperationId) {
        DeleteObjectsEvent event = new DeleteObjectsEvent(1, uniqueOperationId);
        event.setThreadWatcher(threadWatcher);
        return event;
    }

    public static DeleteObjectsEvent newInProgressEvent(ThreadWatcher threadWatcher, StorageObject[] deletedObjects, Object uniqueOperationId) {
        DeleteObjectsEvent event = new DeleteObjectsEvent(3, uniqueOperationId);
        event.setThreadWatcher(threadWatcher);
        event.setObjects(deletedObjects);
        return event;
    }

    public static DeleteObjectsEvent newCompletedEvent(Object uniqueOperationId) {
        DeleteObjectsEvent event = new DeleteObjectsEvent(2, uniqueOperationId);
        return event;
    }

    public static DeleteObjectsEvent newCancelledEvent(StorageObject[] remainingObjects, Object uniqueOperationId) {
        DeleteObjectsEvent event = new DeleteObjectsEvent(4, uniqueOperationId);
        event.setObjects(remainingObjects);
        return event;
    }

    public static DeleteObjectsEvent newIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors, Object uniqueOperationId) {
        DeleteObjectsEvent event = new DeleteObjectsEvent(5, uniqueOperationId);
        event.setIgnoredErrors(ignoredErrors);
        return event;
    }

    private void setObjects(StorageObject[] objects) {
        this.objects = objects;
    }

    public StorageObject[] getDeletedObjects() throws IllegalStateException {
        if (this.getEventCode() != 3) {
            throw new IllegalStateException("Deleted Objects are only available from EVENT_IN_PROGRESS events");
        }
        return this.objects;
    }

    public StorageObject[] getCancelledObjects() throws IllegalStateException {
        if (this.getEventCode() != 4) {
            throw new IllegalStateException("Cancelled Objects are  only available from EVENT_CANCELLED events");
        }
        return this.objects;
    }
}

