/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.s3.org.jets3t.service.multithread;

import alluxio.underfs.s3.org.jets3t.service.model.S3Object;
import alluxio.underfs.s3.org.jets3t.service.multithread.ServiceEvent;
import alluxio.underfs.s3.org.jets3t.service.multithread.ThreadWatcher;

public class GetObjectHeadsEvent
extends ServiceEvent {
    private S3Object[] objects = null;

    private GetObjectHeadsEvent(int eventCode, Object uniqueOperationId) {
        super(eventCode, uniqueOperationId);
    }

    public static GetObjectHeadsEvent newErrorEvent(Throwable t, Object uniqueOperationId) {
        GetObjectHeadsEvent event = new GetObjectHeadsEvent(0, uniqueOperationId);
        event.setErrorCause(t);
        return event;
    }

    public static GetObjectHeadsEvent newStartedEvent(ThreadWatcher threadWatcher, Object uniqueOperationId) {
        GetObjectHeadsEvent event = new GetObjectHeadsEvent(1, uniqueOperationId);
        event.setThreadWatcher(threadWatcher);
        return event;
    }

    public static GetObjectHeadsEvent newInProgressEvent(ThreadWatcher threadWatcher, S3Object[] completedObjects, Object uniqueOperationId) {
        GetObjectHeadsEvent event = new GetObjectHeadsEvent(3, uniqueOperationId);
        event.setThreadWatcher(threadWatcher);
        event.setObjects(completedObjects);
        return event;
    }

    public static GetObjectHeadsEvent newCompletedEvent(Object uniqueOperationId) {
        GetObjectHeadsEvent event = new GetObjectHeadsEvent(2, uniqueOperationId);
        return event;
    }

    public static GetObjectHeadsEvent newCancelledEvent(S3Object[] incompletedObjects, Object uniqueOperationId) {
        GetObjectHeadsEvent event = new GetObjectHeadsEvent(4, uniqueOperationId);
        event.setObjects(incompletedObjects);
        return event;
    }

    public static GetObjectHeadsEvent newIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors, Object uniqueOperationId) {
        GetObjectHeadsEvent event = new GetObjectHeadsEvent(5, uniqueOperationId);
        event.setIgnoredErrors(ignoredErrors);
        return event;
    }

    private void setObjects(S3Object[] objects) {
        this.objects = objects;
    }

    public S3Object[] getCompletedObjects() throws IllegalStateException {
        if (this.getEventCode() != 3) {
            throw new IllegalStateException("Completed Objects are only available from EVENT_IN_PROGRESS events");
        }
        return this.objects;
    }

    public S3Object[] getCancelledObjects() throws IllegalStateException {
        if (this.getEventCode() != 4) {
            throw new IllegalStateException("Cancelled Objects are  only available from EVENT_CANCELLED events");
        }
        return this.objects;
    }
}

