/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.s3.org.jets3t.service.multithread;

import alluxio.underfs.s3.org.jets3t.service.S3Service;
import alluxio.underfs.s3.org.jets3t.service.S3ServiceException;
import alluxio.underfs.s3.org.jets3t.service.model.S3Bucket;
import alluxio.underfs.s3.org.jets3t.service.model.S3Object;
import alluxio.underfs.s3.org.jets3t.service.multithread.CopyObjectsEvent;
import alluxio.underfs.s3.org.jets3t.service.multithread.CreateBucketsEvent;
import alluxio.underfs.s3.org.jets3t.service.multithread.CreateObjectsEvent;
import alluxio.underfs.s3.org.jets3t.service.multithread.DeleteObjectsEvent;
import alluxio.underfs.s3.org.jets3t.service.multithread.DownloadObjectsEvent;
import alluxio.underfs.s3.org.jets3t.service.multithread.DownloadPackage;
import alluxio.underfs.s3.org.jets3t.service.multithread.GetObjectHeadsEvent;
import alluxio.underfs.s3.org.jets3t.service.multithread.LookupACLEvent;
import alluxio.underfs.s3.org.jets3t.service.multithread.S3ServiceEventAdaptor;
import alluxio.underfs.s3.org.jets3t.service.multithread.S3ServiceMulti;
import alluxio.underfs.s3.org.jets3t.service.multithread.UpdateACLEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

@Deprecated
public class S3ServiceSimpleMulti {
    private S3Service s3Service = null;

    public S3ServiceSimpleMulti(S3Service s3Service) {
        this.s3Service = s3Service;
    }

    protected void throwError(S3ServiceEventAdaptor adaptor) throws S3ServiceException {
        if (adaptor.wasErrorThrown()) {
            Throwable thrown = adaptor.getErrorThrown();
            if (thrown instanceof S3ServiceException) {
                throw (S3ServiceException)thrown;
            }
            throw new S3ServiceException(thrown);
        }
    }

    public S3Bucket[] createBuckets(S3Bucket[] buckets) throws S3ServiceException {
        final ArrayList bucketList = new ArrayList();
        S3ServiceEventAdaptor adaptor = new S3ServiceEventAdaptor(){

            public void s3ServiceEventPerformed(CreateBucketsEvent event) {
                super.s3ServiceEventPerformed(event);
                if (3 == event.getEventCode()) {
                    bucketList.addAll(Arrays.asList(event.getCreatedBuckets()));
                }
            }
        };
        new S3ServiceMulti(this.s3Service, adaptor).createBuckets(buckets);
        this.throwError(adaptor);
        return bucketList.toArray(new S3Bucket[bucketList.size()]);
    }

    public S3Object[] putObjects(S3Bucket bucket, S3Object[] objects) throws S3ServiceException {
        final ArrayList objectList = new ArrayList();
        S3ServiceEventAdaptor adaptor = new S3ServiceEventAdaptor(){

            public void s3ServiceEventPerformed(CreateObjectsEvent event) {
                super.s3ServiceEventPerformed(event);
                if (3 == event.getEventCode()) {
                    objectList.addAll(Arrays.asList(event.getCreatedObjects()));
                }
            }
        };
        new S3ServiceMulti(this.s3Service, adaptor).putObjects(bucket, objects);
        this.throwError(adaptor);
        return objectList.toArray(new S3Object[objectList.size()]);
    }

    public Map[] copyObjects(String sourceBucketName, String destinationBucketName, String[] sourceObjectKeys, S3Object[] destinationObjects, boolean replaceMetadata) throws S3ServiceException {
        final ArrayList resultsList = new ArrayList();
        S3ServiceEventAdaptor adaptor = new S3ServiceEventAdaptor(){

            public void s3ServiceEventPerformed(CopyObjectsEvent event) {
                super.s3ServiceEventPerformed(event);
                if (3 == event.getEventCode()) {
                    resultsList.addAll(Arrays.asList(event.getCopyResults()));
                }
            }
        };
        new S3ServiceMulti(this.s3Service, adaptor).copyObjects(sourceBucketName, destinationBucketName, sourceObjectKeys, destinationObjects, replaceMetadata);
        this.throwError(adaptor);
        return resultsList.toArray(new Map[resultsList.size()]);
    }

    public void deleteObjects(S3Bucket bucket, S3Object[] objects) throws S3ServiceException {
        final ArrayList objectList = new ArrayList();
        S3ServiceEventAdaptor adaptor = new S3ServiceEventAdaptor(){

            public void s3ServiceEventPerformed(DeleteObjectsEvent event) {
                super.s3ServiceEventPerformed(event);
                if (3 == event.getEventCode()) {
                    objectList.addAll(Arrays.asList(event.getDeletedObjects()));
                }
            }
        };
        new S3ServiceMulti(this.s3Service, adaptor).deleteObjects(bucket, objects);
        this.throwError(adaptor);
    }

    public void deleteVersionsOfObjectWithMFA(String[] versionIds, String multiFactorSerialNumber, String multiFactorAuthCode, String bucketName, String objectKey) throws S3ServiceException {
        S3ServiceEventAdaptor adaptor = new S3ServiceEventAdaptor();
        new S3ServiceMulti(this.s3Service, adaptor).deleteVersionsOfObjectWithMFA(versionIds, multiFactorSerialNumber, multiFactorAuthCode, bucketName, objectKey);
        this.throwError(adaptor);
    }

    public void deleteVersionsOfObject(String[] versionIds, String bucketName, String objectKey) throws S3ServiceException {
        this.deleteVersionsOfObjectWithMFA(versionIds, null, null, bucketName, objectKey);
    }

    public S3Object[] getObjects(S3Bucket bucket, S3Object[] objects) throws S3ServiceException {
        DownloadPackage[] downloadPackages = new DownloadPackage[objects.length];
        try {
            for (int i = 0; i < downloadPackages.length; ++i) {
                File tempFile = File.createTempFile("jets3t-", ".tmp");
                tempFile.deleteOnExit();
                downloadPackages[i] = new DownloadPackage(objects[i], tempFile);
            }
        }
        catch (IOException e) {
            throw new S3ServiceException("Unable to create temporary file to store object data", e);
        }
        final ArrayList objectList = new ArrayList();
        S3ServiceEventAdaptor adaptor = new S3ServiceEventAdaptor(){

            public void s3ServiceEventPerformed(DownloadObjectsEvent event) {
                super.s3ServiceEventPerformed(event);
                if (3 == event.getEventCode()) {
                    objectList.addAll(Arrays.asList(event.getDownloadedObjects()));
                }
            }
        };
        new S3ServiceMulti(this.s3Service, adaptor).downloadObjects(bucket, downloadPackages);
        this.throwError(adaptor);
        return objectList.toArray(new S3Object[objectList.size()]);
    }

    public S3Object[] getObjects(S3Bucket bucket, String[] objectKeys) throws S3ServiceException {
        S3Object[] objects = new S3Object[objectKeys.length];
        for (int i = 0; i < objectKeys.length; ++i) {
            objects[i] = new S3Object(objectKeys[i]);
        }
        return this.getObjects(bucket, objects);
    }

    public S3Object[] getObjectsHeads(S3Bucket bucket, S3Object[] objects) throws S3ServiceException {
        String[] objectKeys = new String[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            objectKeys[i] = objects[i].getKey();
        }
        return this.getObjectsHeads(bucket, objectKeys);
    }

    public S3Object[] getObjectsHeads(S3Bucket bucket, String[] objectKeys) throws S3ServiceException {
        final ArrayList objectList = new ArrayList();
        S3ServiceEventAdaptor adaptor = new S3ServiceEventAdaptor(){

            public void s3ServiceEventPerformed(GetObjectHeadsEvent event) {
                super.s3ServiceEventPerformed(event);
                if (3 == event.getEventCode()) {
                    objectList.addAll(Arrays.asList(event.getCompletedObjects()));
                }
            }
        };
        new S3ServiceMulti(this.s3Service, adaptor).getObjectsHeads(bucket, objectKeys);
        this.throwError(adaptor);
        return objectList.toArray(new S3Object[objectList.size()]);
    }

    public S3Object[] getObjectACLs(S3Bucket bucket, S3Object[] objects) throws S3ServiceException {
        final ArrayList objectList = new ArrayList();
        S3ServiceEventAdaptor adaptor = new S3ServiceEventAdaptor(){

            public void s3ServiceEventPerformed(LookupACLEvent event) {
                super.s3ServiceEventPerformed(event);
                if (3 == event.getEventCode()) {
                    objectList.addAll(Arrays.asList(event.getObjectsWithACL()));
                }
            }
        };
        new S3ServiceMulti(this.s3Service, adaptor).getObjectACLs(bucket, objects);
        this.throwError(adaptor);
        return objectList.toArray(new S3Object[objectList.size()]);
    }

    public S3Object[] putACLs(S3Bucket bucket, S3Object[] objects) throws S3ServiceException {
        final ArrayList objectList = new ArrayList();
        S3ServiceEventAdaptor adaptor = new S3ServiceEventAdaptor(){

            public void s3ServiceEventPerformed(UpdateACLEvent event) {
                super.s3ServiceEventPerformed(event);
                if (3 == event.getEventCode()) {
                    objectList.addAll(Arrays.asList(event.getObjectsWithUpdatedACL()));
                }
            }
        };
        new S3ServiceMulti(this.s3Service, adaptor).putACLs(bucket, objects);
        this.throwError(adaptor);
        return objectList.toArray(new S3Object[objectList.size()]);
    }

    public void downloadObjects(S3Bucket bucket, DownloadPackage[] downloadPackages) throws S3ServiceException {
        S3ServiceEventAdaptor adaptor = new S3ServiceEventAdaptor();
        new S3ServiceMulti(this.s3Service, adaptor).downloadObjects(bucket, downloadPackages);
        this.throwError(adaptor);
    }
}

