/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.s3.org.jets3t.service.utils;

import alluxio.underfs.s3.org.apache.commons.logging.Log;
import alluxio.underfs.s3.org.apache.commons.logging.LogFactory;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.text.NumberFormatter;

public class ByteFormatter {
    private static final Log log = LogFactory.getLog(ByteFormatter.class);
    private String gigabyteSuffix = null;
    private String megabyteSuffix = null;
    private String kilobyteSuffix = null;
    private String byteSuffix = null;
    private NumberFormatter nf = null;

    public ByteFormatter() {
        this(" GB", " MB", " KB", " B", 2);
    }

    public ByteFormatter(String gigabyteSuffix, String megabyteSuffix, String kilobyteSuffix, String byteSuffix, int decimalPlaces) {
        this.gigabyteSuffix = gigabyteSuffix;
        this.megabyteSuffix = megabyteSuffix;
        this.kilobyteSuffix = kilobyteSuffix;
        this.byteSuffix = byteSuffix;
        StringBuffer numberFormatString = new StringBuffer();
        numberFormatString.append("0").append(decimalPlaces > 0 ? "." : "");
        for (int i = 0; i < decimalPlaces; ++i) {
            numberFormatString.append("0");
        }
        this.nf = new NumberFormatter(new DecimalFormat(numberFormatString.toString()));
    }

    public String formatByteSize(long byteSize) {
        String result = null;
        try {
            if ((double)byteSize > Math.pow(1024.0, 3.0)) {
                result = this.nf.valueToString(new Double((double)byteSize / Math.pow(1024.0, 3.0))) + this.gigabyteSuffix;
            } else if ((double)byteSize > Math.pow(1024.0, 2.0)) {
                result = this.nf.valueToString(new Double((double)byteSize / Math.pow(1024.0, 2.0))) + this.megabyteSuffix;
            } else if (byteSize > 1024L) {
                result = this.nf.valueToString(new Double((double)byteSize / Math.pow(1024.0, 1.0))) + this.kilobyteSuffix;
            } else if (byteSize >= 0L) {
                result = byteSize + this.byteSuffix;
            }
        }
        catch (ParseException e) {
            if (log.isErrorEnabled()) {
                log.error("Unable to format byte size " + byteSize, e);
            }
            return byteSize + this.byteSuffix;
        }
        return result;
    }
}

