/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.s3.org.jets3t.service.utils;

public class TimeFormatter {
    private String hourSuffix = null;
    private String hoursSuffix = null;
    private String minuteSuffix = null;
    private String minutesSuffix = null;
    private String secondSuffix = null;
    private String secondsSuffix = null;

    public TimeFormatter() {
        this(" hour", " hours", " minute", " minutes", " second", " seconds");
    }

    public TimeFormatter(String hourSuffix, String hoursSuffix, String minuteSuffix, String minutesSuffix, String secondSuffix, String secondsSuffix) {
        this.hourSuffix = hourSuffix;
        this.hoursSuffix = hoursSuffix;
        this.minuteSuffix = minuteSuffix;
        this.minutesSuffix = minutesSuffix;
        this.secondSuffix = secondSuffix;
        this.secondsSuffix = secondsSuffix;
    }

    public String formatTime(long seconds) {
        return this.formatTime(seconds, true);
    }

    public String formatTime(long seconds, boolean useUnicodeChars) {
        int hours = 0;
        if (seconds > 3600L) {
            hours = (int)seconds / 3600;
            seconds -= (long)hours * 3600L;
        }
        int mins = (int)seconds / 60;
        seconds -= (long)mins * 60L;
        if (hours > 0) {
            if (mins > 45) {
                return hours + 1 + this.hourSuffix;
            }
            if (mins > 30) {
                if (useUnicodeChars) {
                    return hours + "\u00be" + this.hoursSuffix;
                }
                return hours + " 3/4" + this.hoursSuffix;
            }
            if (mins > 15) {
                if (useUnicodeChars) {
                    return hours + "\u00bd" + this.hoursSuffix;
                }
                return hours + " 1/2" + this.hoursSuffix;
            }
            if (mins > 0) {
                if (useUnicodeChars) {
                    return hours + "\u00bc" + this.hoursSuffix;
                }
                return hours + " 1/4" + this.hoursSuffix;
            }
            return hours + " hour" + (hours > 1 ? "s" : "");
        }
        if (mins > 0) {
            if (seconds > 45L) {
                return mins + 1 + this.minutesSuffix;
            }
            if (seconds > 30L) {
                if (useUnicodeChars) {
                    return mins + "\u00be" + this.minutesSuffix;
                }
                return mins + " 3/4" + this.minutesSuffix;
            }
            if (seconds > 15L) {
                if (useUnicodeChars) {
                    return mins + "\u00bd" + this.minutesSuffix;
                }
                return mins + " 1/2" + this.minutesSuffix;
            }
            if (seconds > 0L) {
                if (useUnicodeChars) {
                    return mins + "\u00bc" + this.minutesSuffix;
                }
                return mins + " 1/4" + this.minutesSuffix;
            }
            return mins + (mins > 1 ? this.minutesSuffix : this.minuteSuffix);
        }
        return seconds + (seconds != 1L ? this.secondsSuffix : this.secondSuffix);
    }
}

