/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service;

import android.content.Context;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.Region;
import org.altbeacon.beacon.logging.LogManager;
import org.altbeacon.beacon.service.Callback;
import org.altbeacon.beacon.service.MonitoringData;
import org.altbeacon.beacon.service.RegionMonitoringState;

public class MonitoringStatus {
    private static volatile MonitoringStatus sInstance;
    private static final int MAX_REGIONS_FOR_STATUS_PRESERVATION = 50;
    private static final int MAX_STATUS_PRESERVATION_FILE_AGE_TO_RESTORE_SECS = 900;
    private static final String TAG;
    public static final String STATUS_PRESERVATION_FILE_NAME = "org.altbeacon.beacon.service.monitoring_status_state";
    private Map<Region, RegionMonitoringState> mRegionsStatesMap;
    private Context mContext;
    private boolean mStatePreservationIsOn = true;
    private static final Object SINGLETON_LOCK;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MonitoringStatus getInstanceForApplication(Context context) {
        MonitoringStatus instance = sInstance;
        if (instance == null) {
            Object object = SINGLETON_LOCK;
            synchronized (object) {
                instance = sInstance;
                if (instance == null) {
                    sInstance = instance = new MonitoringStatus(context.getApplicationContext());
                }
            }
        }
        return instance;
    }

    public MonitoringStatus(Context context) {
        this.mContext = context;
    }

    public synchronized void addRegion(Region region, Callback callback) {
        if (this.getRegionsStateMap().containsKey(region)) {
            for (Region existingRegion : this.getRegionsStateMap().keySet()) {
                if (!existingRegion.equals(region)) continue;
                if (existingRegion.hasSameIdentifiers(region)) {
                    return;
                }
                LogManager.d(TAG, "Replacing region with unique identifier " + region.getUniqueId(), new Object[0]);
                LogManager.d(TAG, "Old definition: " + existingRegion, new Object[0]);
                LogManager.d(TAG, "New definition: " + region, new Object[0]);
                LogManager.d(TAG, "clearing state", new Object[0]);
                this.getRegionsStateMap().remove(region);
                break;
            }
        }
        this.getRegionsStateMap().put(region, new RegionMonitoringState(callback));
        this.saveMonitoringStatusIfOn();
    }

    public synchronized void removeRegion(Region region) {
        this.getRegionsStateMap().remove(region);
        this.saveMonitoringStatusIfOn();
    }

    public synchronized Set<Region> regions() {
        return this.getRegionsStateMap().keySet();
    }

    public synchronized int regionsCount() {
        return this.regions().size();
    }

    public synchronized RegionMonitoringState stateOf(Region region) {
        return this.getRegionsStateMap().get(region);
    }

    public synchronized void updateNewlyOutside() {
        Iterator<Region> monitoredRegionIterator = this.regions().iterator();
        boolean needsMonitoringStateSaving = false;
        while (monitoredRegionIterator.hasNext()) {
            Region region = monitoredRegionIterator.next();
            RegionMonitoringState state = this.stateOf(region);
            if (!state.markOutsideIfExpired()) continue;
            needsMonitoringStateSaving = true;
            LogManager.d(TAG, "found a monitor that expired: %s", region);
            state.getCallback().call(this.mContext, "monitoringData", new MonitoringData(state.getInside(), region));
        }
        if (needsMonitoringStateSaving) {
            this.saveMonitoringStatusIfOn();
        } else {
            this.updateMonitoringStatusTime(System.currentTimeMillis());
        }
    }

    public synchronized void updateNewlyInsideInRegionsContaining(Beacon beacon) {
        List<Region> matchingRegions = this.regionsMatchingTo(beacon);
        boolean needsMonitoringStateSaving = false;
        for (Region region : matchingRegions) {
            RegionMonitoringState state = this.getRegionsStateMap().get(region);
            if (state == null || !state.markInside()) continue;
            needsMonitoringStateSaving = true;
            state.getCallback().call(this.mContext, "monitoringData", new MonitoringData(state.getInside(), region));
        }
        if (needsMonitoringStateSaving) {
            this.saveMonitoringStatusIfOn();
        } else {
            this.updateMonitoringStatusTime(System.currentTimeMillis());
        }
    }

    private Map<Region, RegionMonitoringState> getRegionsStateMap() {
        if (this.mRegionsStatesMap == null) {
            this.restoreOrInitializeMonitoringStatus();
        }
        return this.mRegionsStatesMap;
    }

    private void restoreOrInitializeMonitoringStatus() {
        long millisSinceLastMonitor = System.currentTimeMillis() - this.getLastMonitoringStatusUpdateTime();
        this.mRegionsStatesMap = new HashMap<Region, RegionMonitoringState>();
        if (!this.mStatePreservationIsOn) {
            LogManager.d(TAG, "Not restoring monitoring state because persistence is disabled", new Object[0]);
        } else if (millisSinceLastMonitor > 900000L) {
            LogManager.d(TAG, "Not restoring monitoring state because it was recorded too many milliseconds ago: " + millisSinceLastMonitor, new Object[0]);
        } else {
            this.restoreMonitoringStatus();
            LogManager.d(TAG, "Done restoring monitoring status", new Object[0]);
        }
    }

    private List<Region> regionsMatchingTo(Beacon beacon) {
        ArrayList<Region> matched = new ArrayList<Region>();
        for (Region region : this.regions()) {
            if (region.matchesBeacon(beacon)) {
                matched.add(region);
                continue;
            }
            LogManager.d(TAG, "This region (%s) does not match beacon: %s", region, beacon);
        }
        return matched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveMonitoringStatusIfOn() {
        if (!this.mStatePreservationIsOn) {
            return;
        }
        LogManager.d(TAG, "saveMonitoringStatusIfOn()", new Object[0]);
        if (this.getRegionsStateMap().size() > 50) {
            LogManager.w(TAG, "Too many regions being monitored.  Will not persist region state", new Object[0]);
            this.mContext.deleteFile(STATUS_PRESERVATION_FILE_NAME);
        } else {
            FileOutputStream outputStream = null;
            ObjectOutputStream objectOutputStream = null;
            try {
                outputStream = this.mContext.openFileOutput(STATUS_PRESERVATION_FILE_NAME, 0);
                objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(this.getRegionsStateMap());
            }
            catch (IOException e) {
                LogManager.e(TAG, "Error while saving monitored region states to file. %s ", e.getMessage());
            }
            finally {
                if (null != outputStream) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (objectOutputStream != null) {
                    try {
                        objectOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    protected void updateMonitoringStatusTime(long time) {
        File file = this.mContext.getFileStreamPath(STATUS_PRESERVATION_FILE_NAME);
        file.setLastModified(time);
    }

    protected long getLastMonitoringStatusUpdateTime() {
        File file = this.mContext.getFileStreamPath(STATUS_PRESERVATION_FILE_NAME);
        return file.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restoreMonitoringStatus() {
        FileInputStream inputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            inputStream = this.mContext.openFileInput(STATUS_PRESERVATION_FILE_NAME);
            objectInputStream = new ObjectInputStream(inputStream);
            Map obj = (Map)objectInputStream.readObject();
            LogManager.d(TAG, "Restored region monitoring state for " + obj.size() + " regions.", new Object[0]);
            for (Region region : obj.keySet()) {
                LogManager.d(TAG, "Region  " + region + " uniqueId: " + region.getUniqueId() + " state: " + obj.get(region), new Object[0]);
            }
            for (RegionMonitoringState regionMonitoringState : obj.values()) {
                if (!regionMonitoringState.getInside()) continue;
                regionMonitoringState.markInside();
            }
            this.mRegionsStatesMap.putAll(obj);
        }
        catch (IOException | ClassCastException | ClassNotFoundException e) {
            if (e instanceof InvalidClassException) {
                LogManager.d(TAG, "Serialized Monitoring State has wrong class. Just ignoring saved state...", new Object[0]);
            } else {
                LogManager.e(TAG, "Deserialization exception, message: %s", e.getMessage());
            }
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public synchronized void stopStatusPreservation() {
        this.mContext.deleteFile(STATUS_PRESERVATION_FILE_NAME);
        this.mStatePreservationIsOn = false;
    }

    public synchronized void startStatusPreservation() {
        if (!this.mStatePreservationIsOn) {
            this.mStatePreservationIsOn = true;
            this.saveMonitoringStatusIfOn();
        }
    }

    public synchronized void clear() {
        this.mContext.deleteFile(STATUS_PRESERVATION_FILE_NAME);
        this.getRegionsStateMap().clear();
    }

    static {
        TAG = MonitoringStatus.class.getSimpleName();
        SINGLETON_LOCK = new Object();
    }
}

