/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Build;
import androidx.annotation.RequiresApi;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.Region;
import org.altbeacon.beacon.logging.LogManager;
import org.altbeacon.beacon.service.BeaconService;
import org.altbeacon.beacon.service.ExtraDataBeaconTracker;
import org.altbeacon.beacon.service.ScanHelper;
import org.altbeacon.beacon.service.ScanJobScheduler;
import org.altbeacon.beacon.service.ScanState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 /2\u00020\u0001:\u0001/B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001f\u001a\u00020 H\u0007J\u0006\u0010!\u001a\u00020 J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020#H\u0002J\u000e\u0010%\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u0003J\u0018\u0010&\u001a\u00020 2\u000e\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010)0(H\u0007J\u0006\u0010*\u001a\u00020 J\b\u0010+\u001a\u00020 H\u0007J\u0010\u0010,\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u0003H\u0007J\b\u0010-\u001a\u00020 H\u0007J\b\u0010.\u001a\u00020 H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0013\"\u0004\b\u001e\u0010\u0015\u00a8\u00060"}, d2={"Lorg/altbeacon/beacon/service/IntentScanStrategyCoordinator;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "disableOnFailure", "", "getDisableOnFailure", "()Z", "setDisableOnFailure", "(Z)V", "initialized", "lastCycleEnd", "", "lastStrategyFailureDetectionCount", "", "getLastStrategyFailureDetectionCount", "()I", "setLastStrategyFailureDetectionCount", "(I)V", "longScanForcingEnabled", "scanHelper", "Lorg/altbeacon/beacon/service/ScanHelper;", "scanState", "Lorg/altbeacon/beacon/service/ScanState;", "started", "strategyFailureDetectionCount", "getStrategyFailureDetectionCount", "setStrategyFailureDetectionCount", "applySettings", "", "ensureInitialized", "getManifestMetadataValue", "", "key", "performPeriodicProcessing", "processScanResults", "scanResults", "Ljava/util/ArrayList;", "Landroid/bluetooth/le/ScanResult;", "reinitialize", "restartBackgroundScan", "runBackupScan", "start", "stop", "Companion", "android-beacon-library_release"})
public final class IntentScanStrategyCoordinator {
    private ScanHelper scanHelper;
    private ScanState scanState;
    private boolean initialized;
    private boolean started;
    private boolean longScanForcingEnabled;
    private long lastCycleEnd;
    private int strategyFailureDetectionCount;
    private int lastStrategyFailureDetectionCount;
    private boolean disableOnFailure;
    @NotNull
    private final Context context;
    @NotNull
    private static final String TAG;
    @NotNull
    public static final Companion Companion;

    public final int getStrategyFailureDetectionCount() {
        return this.strategyFailureDetectionCount;
    }

    public final void setStrategyFailureDetectionCount(int n) {
        this.strategyFailureDetectionCount = n;
    }

    public final int getLastStrategyFailureDetectionCount() {
        return this.lastStrategyFailureDetectionCount;
    }

    public final void setLastStrategyFailureDetectionCount(int n) {
        this.lastStrategyFailureDetectionCount = n;
    }

    public final boolean getDisableOnFailure() {
        return this.disableOnFailure;
    }

    public final void setDisableOnFailure(boolean bl) {
        this.disableOnFailure = bl;
    }

    public final void ensureInitialized() {
        if (!this.initialized) {
            this.initialized = true;
            this.scanHelper = new ScanHelper(this.context);
            this.reinitialize();
        }
    }

    public final void reinitialize() {
        if (!this.initialized) {
            this.ensureInitialized();
            return;
        }
        ScanState newScanState = ScanState.restore(this.context);
        if (newScanState == null) {
            newScanState = new ScanState(this.context);
        }
        ScanState scanState = this.scanState = newScanState;
        if (scanState == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanState");
        }
        scanState.setLastScanStartTimeMillis(System.currentTimeMillis());
        ScanHelper scanHelper = this.scanHelper;
        if (scanHelper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanHelper");
        }
        ScanState scanState2 = this.scanState;
        if (scanState2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanState");
        }
        scanHelper.setMonitoringStatus(scanState2.getMonitoringStatus());
        ScanHelper scanHelper2 = this.scanHelper;
        if (scanHelper2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanHelper");
        }
        ScanState scanState3 = this.scanState;
        if (scanState3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanState");
        }
        scanHelper2.setRangedRegionState(scanState3.getRangedRegionState());
        ScanHelper scanHelper3 = this.scanHelper;
        if (scanHelper3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanHelper");
        }
        ScanState scanState4 = this.scanState;
        if (scanState4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanState");
        }
        scanHelper3.setBeaconParsers(scanState4.getBeaconParsers());
        ScanHelper scanHelper4 = this.scanHelper;
        if (scanHelper4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanHelper");
        }
        ScanState scanState5 = this.scanState;
        if (scanState5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanState");
        }
        scanHelper4.setExtraDataBeaconTracker(scanState5.getExtraBeaconDataTracker());
    }

    @RequiresApi(value=26)
    public final void applySettings() {
        this.reinitialize();
        ScanState scanState = this.scanState;
        if (scanState == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanState");
        }
        scanState.applyChanges(BeaconManager.getInstanceForApplication(this.context));
        this.restartBackgroundScan();
    }

    @RequiresApi(value=26)
    public final void start() {
        Region region;
        this.started = true;
        this.ensureInitialized();
        BeaconManager beaconManager = BeaconManager.getInstanceForApplication(this.context);
        Intrinsics.checkNotNullExpressionValue((Object)beaconManager, (String)"BeaconManager.getInstanceForApplication(context)");
        BeaconManager beaconManager2 = beaconManager;
        ScanHelper scanHelper = this.scanHelper;
        if (scanHelper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanHelper");
        }
        scanHelper.setExtraDataBeaconTracker(new ExtraDataBeaconTracker());
        beaconManager2.setScannerInSameProcess(true);
        String longScanForcingEnabledString = this.getManifestMetadataValue("longScanForcingEnabled");
        if (longScanForcingEnabledString != null && Intrinsics.areEqual((Object)longScanForcingEnabledString, (Object)"true")) {
            LogManager.i("BeaconService", "longScanForcingEnabled to keep scans going on Android N for > 30 minutes", new Object[0]);
            this.longScanForcingEnabled = true;
        }
        ScanHelper scanHelper2 = this.scanHelper;
        if (scanHelper2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanHelper");
        }
        scanHelper2.reloadParsers();
        LogManager.d(TAG, "starting background scan", new Object[0]);
        HashSet<Region> regions = new HashSet<Region>();
        HashSet<Region> wildcardRegions = new HashSet<Region>();
        Iterator<Region> iterator = beaconManager2.getRangedRegions().iterator();
        while (iterator.hasNext()) {
            Region region2 = region = iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)region2, (String)"region");
            if (region2.getIdentifiers().size() == 0) {
                wildcardRegions.add(region);
                continue;
            }
            regions.add(region);
        }
        iterator = beaconManager2.getMonitoredRegions().iterator();
        while (iterator.hasNext()) {
            Region region3 = region = iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)region3, (String)"region");
            if (region3.getIdentifiers().size() == 0) {
                wildcardRegions.add(region);
                continue;
            }
            regions.add(region);
        }
        if (wildcardRegions.size() > 0) {
            if (regions.size() > 0) {
                LogManager.w(TAG, "Wildcard regions are being used for beacon ranging or monitoring.  The wildcard regions are ignored with intent scan strategy active.", new Object[0]);
            } else {
                regions = wildcardRegions;
            }
        }
        ScanHelper scanHelper3 = this.scanHelper;
        if (scanHelper3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanHelper");
        }
        ScanState scanState = this.scanState;
        if (scanState == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanState");
        }
        scanHelper3.startAndroidOBackgroundScan(scanState.getBeaconParsers(), new ArrayList(regions));
        this.lastCycleEnd = System.currentTimeMillis();
        ScanJobScheduler.getInstance().scheduleForIntentScanStrategy(this.context);
    }

    private final String getManifestMetadataValue(String key) {
        String value = null;
        try {
            ServiceInfo serviceInfo = this.context.getPackageManager().getServiceInfo(new ComponentName(this.context, BeaconService.class), 128);
            Intrinsics.checkNotNullExpressionValue((Object)serviceInfo, (String)"context.getPackageManage\u2026T_META_DATA\n            )");
            PackageItemInfo info = (PackageItemInfo)serviceInfo;
            if (info != null && info.metaData != null) {
                return String.valueOf(info.metaData.get(key));
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return null;
    }

    @RequiresApi(value=26)
    public final void stop() {
        this.ensureInitialized();
        LogManager.d(TAG, "stopping background scan", new Object[0]);
        ScanHelper scanHelper = this.scanHelper;
        if (scanHelper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanHelper");
        }
        scanHelper.stopAndroidOBackgroundScan();
        ScanJobScheduler.getInstance().cancelSchedule(this.context);
        this.started = false;
    }

    @RequiresApi(value=26)
    public final void restartBackgroundScan() {
        this.ensureInitialized();
        LogManager.d(TAG, "restarting background scan", new Object[0]);
        ScanHelper scanHelper = this.scanHelper;
        if (scanHelper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanHelper");
        }
        scanHelper.stopAndroidOBackgroundScan();
        ScanHelper scanHelper2 = this.scanHelper;
        if (scanHelper2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanHelper");
        }
        ScanState scanState = this.scanState;
        if (scanState == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanState");
        }
        scanHelper2.startAndroidOBackgroundScan(scanState.getBeaconParsers());
    }

    @RequiresApi(value=26)
    public final void processScanResults(@NotNull ArrayList<ScanResult> scanResults) {
        Intrinsics.checkNotNullParameter(scanResults, (String)"scanResults");
        this.ensureInitialized();
        for (ScanResult scanResult : scanResults) {
            if (scanResult == null) continue;
            ScanHelper scanHelper = this.scanHelper;
            if (scanHelper == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"scanHelper");
            }
            ScanRecord scanRecord = scanResult.getScanRecord();
            scanHelper.processScanResult(scanResult.getDevice(), scanResult.getRssi(), (byte[])(scanRecord != null ? scanRecord.getBytes() : null), scanResult.getTimestampNanos() / (long)1000);
        }
        long now = System.currentTimeMillis();
        BeaconManager beaconManager = BeaconManager.getInstanceForApplication(this.context);
        Intrinsics.checkNotNullExpressionValue((Object)beaconManager, (String)"BeaconManager.getInstanceForApplication(context)");
        BeaconManager beaconManager2 = beaconManager;
        long scanPeriod = beaconManager2.getForegroundScanPeriod();
        if (beaconManager2.getBackgroundMode()) {
            scanPeriod = beaconManager2.getBackgroundScanPeriod();
        }
        if (now - this.lastCycleEnd > scanPeriod) {
            LogManager.d(TAG, "End of scan cycle", new Object[0]);
            this.lastCycleEnd = now;
            ScanHelper scanHelper = this.scanHelper;
            if (scanHelper == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"scanHelper");
            }
            scanHelper.getCycledLeScanCallback().onCycleEnd();
        }
    }

    public final void performPeriodicProcessing(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Build.VERSION.SDK_INT >= 26) {
            this.processScanResults(new ArrayList<ScanResult>());
            this.runBackupScan(context);
        }
    }

    @RequiresApi(value=21)
    public final void runBackupScan(@NotNull Context context) {
        boolean anythingDetectedWithIntentScan;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!this.started) {
            LogManager.i(TAG, "Not doing backup scan because we are not started", new Object[0]);
            return;
        }
        LogManager.i(TAG, "Starting backup scan", new Object[0]);
        Object object = context.getSystemService("bluetooth");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.bluetooth.BluetoothManager");
        }
        BluetoothManager manager = (BluetoothManager)object;
        BluetoothAdapter adapter = manager.getAdapter();
        boolean beaconDetected = false;
        long scanStartTime = System.currentTimeMillis();
        ScanHelper scanHelper = this.scanHelper;
        if (scanHelper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanHelper");
        }
        if (anythingDetectedWithIntentScan = scanHelper.anyBeaconsDetectedThisCycle()) {
            LogManager.d(TAG, "We have detected beacons with the intent scan.  No need to do a backup scan.", new Object[0]);
            this.strategyFailureDetectionCount = 0;
            this.lastStrategyFailureDetectionCount = 0;
            return;
        }
        if (adapter != null) {
            BluetoothLeScanner bluetoothLeScanner = adapter.getBluetoothLeScanner();
            Intrinsics.checkNotNullExpressionValue((Object)bluetoothLeScanner, (String)"adapter.getBluetoothLeScanner()");
            BluetoothLeScanner scanner = bluetoothLeScanner;
            ScanCallback callback2 = new ScanCallback(this, scanner){
                final /* synthetic */ IntentScanStrategyCoordinator this$0;
                final /* synthetic */ BluetoothLeScanner $scanner;

                public void onScanResult(int callbackType, @NotNull ScanResult result) {
                    Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                    super.onScanResult(callbackType, result);
                    ScanRecord scanRecord = result.getScanRecord();
                    IntentScanStrategyCoordinator.access$getScanHelper$p(this.this$0).processScanResult(result.getDevice(), result.getRssi(), (byte[])(scanRecord != null ? scanRecord.getBytes() : null), result.getTimestampNanos());
                    try {
                        this.$scanner.stopScan((ScanCallback)this);
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }

                public void onBatchScanResults(@NotNull List<ScanResult> results) {
                    Intrinsics.checkNotNullParameter(results, (String)"results");
                    super.onBatchScanResults(results);
                }

                public void onScanFailed(int errorCode) {
                    super.onScanFailed(errorCode);
                    LogManager.d(IntentScanStrategyCoordinator.Companion.getTAG(), "Sending onScanFailed event", new Object[0]);
                }
                {
                    this.this$0 = this$0;
                    this.$scanner = $captured_local_variable$1;
                }
            };
            if (scanner != null) {
                try {
                    scanner.startScan(callback2);
                    while (true) {
                        LogManager.d(TAG, "Waiting for beacon detection...", new Object[0]);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (System.currentTimeMillis() - scanStartTime > 30000L) break;
                        ScanHelper scanHelper2 = this.scanHelper;
                        if (scanHelper2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"scanHelper");
                        }
                        if (!scanHelper2.anyBeaconsDetectedThisCycle()) continue;
                        if (this.strategyFailureDetectionCount == this.lastStrategyFailureDetectionCount) {
                            LogManager.e(TAG, "We have detected a beacon with the backup scan without a filter.  We never detected one with the intent scan with a filter.  This technique will not work.", new Object[0]);
                        }
                        this.lastStrategyFailureDetectionCount = this.strategyFailureDetectionCount;
                        int n = this.strategyFailureDetectionCount;
                        this.strategyFailureDetectionCount = n + 1;
                    }
                    LogManager.d(TAG, "Timeout running backup scan to look for beacons", new Object[0]);
                    scanner.stopScan(callback2);
                }
                catch (IllegalStateException e) {
                    LogManager.d(TAG, "Bluetooth is off.  Cannot run backup scan", new Object[0]);
                }
                catch (NullPointerException e) {
                    LogManager.e(TAG, "NullPointerException. Cannot run backup scan", e);
                }
            } else {
                LogManager.d(TAG, "Cannot get scanner", new Object[0]);
            }
        }
        LogManager.d(TAG, "backup scan complete", new Object[0]);
        if (this.disableOnFailure && this.strategyFailureDetectionCount > 0) {
            BeaconManager.getInstanceForApplication(context).handleStategyFailover();
        }
        if (Build.VERSION.SDK_INT >= 26) {
            this.processScanResults(new ArrayList<ScanResult>());
        }
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public IntentScanStrategyCoordinator(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    static {
        Companion = new Companion(null);
        TAG = "IntentScanCoord";
    }

    public static final /* synthetic */ ScanHelper access$getScanHelper$p(IntentScanStrategyCoordinator $this) {
        ScanHelper scanHelper = $this.scanHelper;
        if (scanHelper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanHelper");
        }
        return scanHelper;
    }

    public static final /* synthetic */ void access$setScanHelper$p(IntentScanStrategyCoordinator $this, ScanHelper scanHelper) {
        $this.scanHelper = scanHelper;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/altbeacon/beacon/service/IntentScanStrategyCoordinator$Companion;", "", "()V", "TAG", "", "getTAG", "()Ljava/lang/String;", "android-beacon-library_release"})
    public static final class Companion {
        @NotNull
        public final String getTAG() {
            return TAG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

