/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.bluetooth;

import java.util.ArrayList;
import java.util.List;
import org.altbeacon.bluetooth.Pdu;

public class BleAdvertisement {
    private static final String TAG = "BleAdvertisement";
    private List<Pdu> mPdus;
    private byte[] mBytes;

    public BleAdvertisement(byte[] bytes) {
        this.mBytes = bytes;
        ArrayList<Pdu> pdus = new ArrayList<Pdu>();
        this.parsePdus(0, bytes.length < 31 ? bytes.length : 31, pdus);
        if (bytes.length > 31) {
            this.parsePdus(31, bytes.length, pdus);
        }
        this.mPdus = pdus;
    }

    private void parsePdus(int startIndex, int endIndex, ArrayList<Pdu> pdus) {
        int index = startIndex;
        Pdu pdu = null;
        do {
            if ((pdu = Pdu.parse(this.mBytes, index)) == null) continue;
            index = index + pdu.getDeclaredLength() + 1;
            pdus.add(pdu);
        } while (pdu != null && index < endIndex);
    }

    public List<Pdu> getPdus() {
        return this.mPdus;
    }
}

