/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service;

import org.altbeacon.beacon.logging.LogManager;
import org.altbeacon.beacon.service.RssiFilter;

public class ArmaRssiFilter
implements RssiFilter {
    private static double DEFAULT_ARMA_SPEED = 0.1;
    private static final String TAG = "ArmaRssiFilter";
    private int armaMeasurement;
    private double armaSpeed = DEFAULT_ARMA_SPEED;
    private boolean isInitialized = false;

    @Override
    public void addMeasurement(Integer rssi) {
        LogManager.d(TAG, "adding rssi: %s", rssi);
        if (!this.isInitialized) {
            this.armaMeasurement = rssi;
            this.isInitialized = true;
        }
        this.armaMeasurement = Double.valueOf((double)this.armaMeasurement - this.armaSpeed * (double)(this.armaMeasurement - rssi)).intValue();
        LogManager.d(TAG, "armaMeasurement: %s", this.armaMeasurement);
    }

    @Override
    public int getMeasurementCount() {
        return 0;
    }

    @Override
    public boolean noMeasurementsAvailable() {
        return false;
    }

    @Override
    public double calculateRssi() {
        return this.armaMeasurement;
    }

    public static void setDEFAULT_ARMA_SPEED(double default_arma_speed) {
        DEFAULT_ARMA_SPEED = default_arma_speed;
    }
}

