/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.utils;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.os.Build;
import android.os.PowerManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.altbeacon.beacon.logging.LogManager;

public class DozeDetector {
    private static final String TAG = DozeDetector.class.getSimpleName();

    public boolean isInDozeMode(Context context) {
        return this.isInFullDozeMode(context) || this.isInLightDozeMode(context);
    }

    public boolean isInLightDozeMode(Context context) {
        if (Build.VERSION.SDK_INT >= 21) {
            PowerManager pm = (PowerManager)context.getSystemService("power");
            try {
                Method isLightDeviceIdleModeMethod = pm.getClass().getDeclaredMethod("isLightDeviceIdleMode", new Class[0]);
                boolean result = (Boolean)isLightDeviceIdleModeMethod.invoke((Object)pm, new Object[0]);
                LogManager.d(TAG, "Light Doze mode? pm.isLightDeviceIdleMode: " + result, new Object[0]);
                return result;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LogManager.d(TAG, "Reflection failed for isLightDeviceIdleMode: " + e.toString(), e);
            }
        } else {
            LogManager.d(TAG, "We can't be in doze mode as we are pre-Android M", new Object[0]);
        }
        return false;
    }

    public boolean isInFullDozeMode(Context context) {
        if (Build.VERSION.SDK_INT >= 21) {
            PowerManager pm = (PowerManager)context.getSystemService("power");
            if (pm == null) {
                LogManager.d(TAG, "Can't get PowerManager to check doze mode.", new Object[0]);
                return false;
            }
            if (Build.VERSION.SDK_INT >= 23) {
                LogManager.d(TAG, "Full Doze mode? pm.isDeviceIdleMode()=" + pm.isDeviceIdleMode(), new Object[0]);
                if (pm.isDeviceIdleMode()) {
                    return true;
                }
            }
            LogManager.d(TAG, "Doze mode? pm.isPowerSaveMode()=" + pm.isPowerSaveMode(), new Object[0]);
            return pm.isPowerSaveMode();
        }
        LogManager.d(TAG, "We can't be in doze mode as we are pre-Android M", new Object[0]);
        return false;
    }

    public void registerDozeCallbacks(Context context, BroadcastReceiver receiver) {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.os.action.DEVICE_IDLE_MODE_CHANGED");
        context.registerReceiver(receiver, filter);
        filter = new IntentFilter();
        String action = this.getLightIdleModeChangeAction();
        filter.addAction(action);
        context.registerReceiver(receiver, filter);
    }

    public String getLightIdleModeChangeAction() {
        String action = "android.os.action.LIGHT_DEVICE_IDLE_MODE_CHANGE";
        if (Build.VERSION.SDK_INT >= 21) {
            try {
                Object reflectionAction = PowerManager.class.getField("ACTION_LIGHT_DEVICE_IDLE_MODE_CHANGED").get(null);
                if (reflectionAction != null && reflectionAction instanceof String) {
                    action = (String)reflectionAction;
                }
            }
            catch (Exception e) {
                LogManager.d(TAG, "Cannot get LIGHT_DEVICE_IDLE_MODE_CHANGE action: " + e.toString(), e);
            }
        }
        return action;
    }
}

