/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service.scanner;

import android.annotation.TargetApi;
import android.bluetooth.le.ScanFilter;
import android.os.ParcelUuid;
import java.util.ArrayList;
import java.util.List;
import org.altbeacon.beacon.BeaconParser;
import org.altbeacon.beacon.Identifier;
import org.altbeacon.beacon.Region;
import org.altbeacon.beacon.logging.LogManager;

@TargetApi(value=21)
public class ScanFilterUtils {
    public static final String TAG = "ScanFilterUtils";

    public List<ScanFilter> createWildcardScanFilters() {
        ArrayList<ScanFilter> scanFilters = new ArrayList<ScanFilter>();
        ScanFilter.Builder builder = new ScanFilter.Builder();
        scanFilters.add(builder.build());
        return scanFilters;
    }

    public List<ScanFilterData> createScanFilterDataForBeaconParser(BeaconParser beaconParser, List<Identifier> identifiers) {
        int[] nArray;
        int n;
        int n2;
        ArrayList<ScanFilterData> scanFilters = new ArrayList<ScanFilterData>();
        long typeCode = beaconParser.getMatchingBeaconTypeCode();
        int startOffset = beaconParser.getMatchingBeaconTypeCodeStartOffset();
        int endOffset = beaconParser.getMatchingBeaconTypeCodeEndOffset();
        byte[] typeCodeBytes = BeaconParser.longToByteArray(typeCode, endOffset - startOffset + 1);
        if (identifiers != null && identifiers.size() > 0 && identifiers.get(0) != null && beaconParser.getMatchingBeaconTypeCode() == 533L && (n2 = 0) < (n = (nArray = beaconParser.getHardwareAssistManufacturers()).length)) {
            int i;
            int manufacturer = nArray[n2];
            ScanFilterData sfd = new ScanFilterData();
            sfd.manufacturer = manufacturer;
            int length = 18;
            if (identifiers.size() == 2) {
                length = 20;
            }
            if (identifiers.size() == 3) {
                length = 22;
            }
            sfd.filter = new byte[length];
            sfd.filter[0] = typeCodeBytes[0];
            sfd.filter[1] = typeCodeBytes[1];
            byte[] idBytes = identifiers.get(0).toByteArray();
            for (i = 0; i < idBytes.length; ++i) {
                sfd.filter[i + 2] = idBytes[i];
            }
            if (identifiers.size() > 1 && identifiers.get(1) != null) {
                idBytes = identifiers.get(1).toByteArray();
                for (i = 0; i < idBytes.length; ++i) {
                    sfd.filter[i + 18] = idBytes[i];
                }
            }
            if (identifiers.size() > 2 && identifiers.get(2) != null) {
                idBytes = identifiers.get(2).toByteArray();
                for (i = 0; i < idBytes.length; ++i) {
                    sfd.filter[i + 20] = idBytes[i];
                }
            }
            sfd.mask = new byte[length];
            for (i = 0; i < length; ++i) {
                sfd.mask[i] = -1;
            }
            sfd.serviceUuid = null;
            sfd.serviceUuid128Bit = new byte[0];
            scanFilters.add(sfd);
            return scanFilters;
        }
        for (int manufacturer : beaconParser.getHardwareAssistManufacturers()) {
            ScanFilterData sfd = new ScanFilterData();
            Long serviceUuid = beaconParser.getServiceUuid();
            int offset = 2;
            if (beaconParser.getServiceUuid128Bit().length > 0) {
                offset = beaconParser.getServiceUuid128Bit().length;
            }
            int length = endOffset + 1 - offset;
            byte[] filter = new byte[]{};
            byte[] mask = new byte[]{};
            if (length > 0) {
                filter = new byte[length];
                mask = new byte[length];
                for (int layoutIndex = offset; layoutIndex <= endOffset; ++layoutIndex) {
                    int filterIndex = layoutIndex - offset;
                    if (layoutIndex < startOffset) {
                        filter[filterIndex] = 0;
                        mask[filterIndex] = 0;
                        continue;
                    }
                    filter[filterIndex] = typeCodeBytes[layoutIndex - startOffset];
                    mask[filterIndex] = -1;
                }
            }
            sfd.manufacturer = manufacturer;
            sfd.filter = filter;
            sfd.mask = mask;
            sfd.serviceUuid = serviceUuid;
            sfd.serviceUuid128Bit = beaconParser.getServiceUuid128Bit();
            scanFilters.add(sfd);
        }
        return scanFilters;
    }

    public List<ScanFilter> createScanFiltersForBeaconParsers(List<BeaconParser> beaconParsers) {
        return this.createScanFiltersForBeaconParsers(beaconParsers, null);
    }

    public List<ScanFilter> createScanFiltersForBeaconParsers(List<BeaconParser> beaconParsers, List<Region> regions) {
        ArrayList<Region> nonNullRegions = new ArrayList<Region>();
        if (regions == null) {
            nonNullRegions.add(null);
        } else {
            nonNullRegions.addAll(regions);
        }
        ArrayList<ScanFilter> scanFilters = new ArrayList<ScanFilter>();
        for (Region region : nonNullRegions) {
            for (BeaconParser beaconParser : beaconParsers) {
                List<ScanFilterData> sfds = this.createScanFilterDataForBeaconParser(beaconParser, region == null ? null : region.getIdentifiers());
                for (ScanFilterData sfd : sfds) {
                    ScanFilter.Builder builder = new ScanFilter.Builder();
                    if (sfd.serviceUuid != null) {
                        serviceUuidString = String.format("0000%04X-0000-1000-8000-00805f9b34fb", sfd.serviceUuid);
                        serviceUuidMaskString = "FFFFFFFF-FFFF-FFFF-FFFF-FFFFFFFFFFFF";
                        parcelUuid = ParcelUuid.fromString((String)serviceUuidString);
                        parcelUuidMask = ParcelUuid.fromString((String)serviceUuidMaskString);
                        if (LogManager.isVerboseLoggingEnabled()) {
                            LogManager.d(TAG, "making scan filter for service: " + serviceUuidString + " " + parcelUuid, new Object[0]);
                            LogManager.d(TAG, "making scan filter with service mask: " + serviceUuidMaskString + " " + parcelUuidMask, new Object[0]);
                        }
                        builder.setServiceData(parcelUuid, sfd.filter, sfd.mask);
                    } else if (sfd.serviceUuid128Bit.length == 16) {
                        serviceUuidString = Identifier.fromBytes(sfd.serviceUuid128Bit, 0, 16, true).toString();
                        serviceUuidMaskString = "FFFFFFFF-FFFF-FFFF-FFFF-FFFFFFFFFFFF";
                        parcelUuid = ParcelUuid.fromString((String)serviceUuidString);
                        parcelUuidMask = ParcelUuid.fromString((String)serviceUuidMaskString);
                        if (LogManager.isVerboseLoggingEnabled()) {
                            LogManager.d(TAG, "making scan filter for service: " + serviceUuidString + " " + parcelUuid, new Object[0]);
                            LogManager.d(TAG, "making scan filter with service mask: " + serviceUuidMaskString + " " + parcelUuidMask, new Object[0]);
                        }
                        if (beaconParser.getIdentifierCount() > 0) {
                            builder.setServiceData(parcelUuid, sfd.filter, sfd.mask);
                        } else {
                            builder.setServiceUuid(parcelUuid, parcelUuidMask);
                        }
                    } else {
                        builder.setServiceUuid(null);
                        builder.setManufacturerData(sfd.manufacturer, sfd.filter, sfd.mask);
                        if (LogManager.isVerboseLoggingEnabled()) {
                            LogManager.d(TAG, "making scan filter for manufacturer: " + sfd.manufacturer + " " + sfd.filter, new Object[0]);
                        }
                    }
                    ScanFilter scanFilter = builder.build();
                    if (LogManager.isVerboseLoggingEnabled()) {
                        LogManager.d(TAG, "Set up a scan filter: " + scanFilter, new Object[0]);
                    }
                    scanFilters.add(scanFilter);
                }
            }
        }
        if (scanFilters.size() == 0) {
            LogManager.d(TAG, "Using no scan filters.", new Object[0]);
        } else {
            for (ScanFilter scanFilter : scanFilters) {
                LogManager.d(TAG, "Using scan filter: " + scanFilter, new Object[0]);
            }
        }
        return scanFilters;
    }

    class ScanFilterData {
        public Long serviceUuid = null;
        public byte[] serviceUuid128Bit = new byte[0];
        public int manufacturer;
        public byte[] filter;
        public byte[] mask;

        ScanFilterData() {
        }
    }
}

