/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.distance;

import android.content.ContentResolver;
import android.content.Context;
import android.os.AsyncTask;
import android.provider.Settings;
import org.altbeacon.beacon.distance.AndroidModel;
import org.altbeacon.beacon.distance.DistanceConfigFetcher;

public class ModelSpecificDistanceUpdater
extends AsyncTask<Void, Void, Void> {
    private static final String TAG = "ModelSpecificDistanceUpdater";
    private Exception exception = null;
    private String urlString = null;
    private String response = null;
    private Context mContext;
    private DistanceConfigFetcher mDistanceConfigFetcher;
    private CompletionHandler mCompletionHandler;

    protected Void doInBackground(Void ... params) {
        this.mDistanceConfigFetcher.request();
        if (this.mCompletionHandler != null) {
            this.mCompletionHandler.onComplete(this.mDistanceConfigFetcher.getResponseString(), this.mDistanceConfigFetcher.getException(), this.mDistanceConfigFetcher.getResponseCode());
        }
        return null;
    }

    protected void onPostExecute() {
    }

    public ModelSpecificDistanceUpdater(Context context, String urlString, CompletionHandler completionHandler) {
        this.mContext = context;
        this.mDistanceConfigFetcher = new DistanceConfigFetcher(urlString, this.getUserAgentString());
        this.mCompletionHandler = completionHandler;
    }

    private String getUserAgentString() {
        return "Android Beacon Library;" + this.getVersion() + ";" + this.getPackage() + ";" + this.getInstallId() + ";" + this.getModel();
    }

    private String getPackage() {
        return this.mContext.getPackageName();
    }

    private String getModel() {
        return AndroidModel.forThisDevice().toString();
    }

    private String getInstallId() {
        return Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"android_id");
    }

    private String getVersion() {
        return "2.21.1-beta4";
    }

    static interface CompletionHandler {
        public void onComplete(String var1, Exception var2, int var3);
    }
}

