/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service;

import android.annotation.TargetApi;
import android.app.Service;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.BeaconParser;
import org.altbeacon.beacon.Region;
import org.altbeacon.beacon.distance.DistanceCalculator;
import org.altbeacon.beacon.distance.ModelSpecificDistanceCalculator;
import org.altbeacon.beacon.logging.LogManager;
import org.altbeacon.beacon.service.Callback;
import org.altbeacon.beacon.service.DetectionTracker;
import org.altbeacon.beacon.service.GattBeaconTracker;
import org.altbeacon.beacon.service.MonitorState;
import org.altbeacon.beacon.service.MonitoringData;
import org.altbeacon.beacon.service.RangeState;
import org.altbeacon.beacon.service.RangingData;
import org.altbeacon.beacon.service.StartRMData;
import org.altbeacon.beacon.service.Stats;
import org.altbeacon.beacon.service.scanner.CycledLeScanCallback;
import org.altbeacon.beacon.service.scanner.CycledLeScanner;
import org.altbeacon.bluetooth.BluetoothCrashResolver;

@TargetApi(value=5)
public class BeaconService
extends Service {
    public static final String TAG = "BeaconService";
    private Map<Region, RangeState> rangedRegionState = new HashMap<Region, RangeState>();
    private Map<Region, MonitorState> monitoredRegionState = new HashMap<Region, MonitorState>();
    int trackedBeaconsPacketCount;
    private Handler handler = new Handler();
    private int bindCount = 0;
    private BluetoothCrashResolver bluetoothCrashResolver;
    private DistanceCalculator defaultDistanceCalculator = null;
    private List<BeaconParser> beaconParsers;
    private CycledLeScanner mCycledScanner;
    private boolean mBackgroundFlag = false;
    private GattBeaconTracker mGattBeaconTracker = new GattBeaconTracker();
    private ExecutorService mExecutor;
    private List<Beacon> simulatedScanData = null;
    public static final int MSG_START_RANGING = 2;
    public static final int MSG_STOP_RANGING = 3;
    public static final int MSG_START_MONITORING = 4;
    public static final int MSG_STOP_MONITORING = 5;
    public static final int MSG_SET_SCAN_PERIODS = 6;
    final Messenger mMessenger = new Messenger((Handler)new IncomingHandler(this));
    protected CycledLeScanCallback mCycledLeScanCallback = new CycledLeScanCallback(){

        @Override
        @TargetApi(value=11)
        public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
            try {
                new ScanProcessor().executeOnExecutor(BeaconService.this.mExecutor, new ScanData[]{new ScanData(device, rssi, scanRecord)});
            }
            catch (RejectedExecutionException e) {
                LogManager.w(BeaconService.TAG, "Ignoring scan result because we cannot keep up.", new Object[0]);
            }
        }

        @Override
        public void onCycleEnd() {
            BeaconService.this.processExpiredMonitors();
            BeaconService.this.processRangeData();
            if (BeaconService.this.simulatedScanData != null) {
                LogManager.w(BeaconService.TAG, "Simulated scan data is deprecated and will be removed in a future release. Please use the new BeaconSimulator interface instead.", new Object[0]);
                if (0 != (BeaconService.this.getApplicationInfo().flags &= 2)) {
                    for (Beacon beacon : BeaconService.this.simulatedScanData) {
                        BeaconService.this.processBeaconFromScan(beacon);
                    }
                } else {
                    LogManager.w(BeaconService.TAG, "Simulated scan data provided, but ignored because we are not running in debug mode.  Please remove simulated scan data for production.", new Object[0]);
                }
            }
            if (BeaconManager.getBeaconSimulator() != null) {
                if (BeaconManager.getBeaconSimulator().getBeacons() != null) {
                    if (0 != (BeaconService.this.getApplicationInfo().flags &= 2)) {
                        for (Beacon beacon : BeaconManager.getBeaconSimulator().getBeacons()) {
                            BeaconService.this.processBeaconFromScan(beacon);
                        }
                    } else {
                        LogManager.w(BeaconService.TAG, "Beacon simulations provided, but ignored because we are not running in debug mode.  Please remove beacon simulations for production.", new Object[0]);
                    }
                } else {
                    LogManager.w(BeaconService.TAG, "getBeacons is returning null. No simulated beacons to report.", new Object[0]);
                }
            }
        }
    };

    public IBinder onBind(Intent intent) {
        LogManager.i(TAG, "binding", new Object[0]);
        ++this.bindCount;
        return this.mMessenger.getBinder();
    }

    public boolean onUnbind(Intent intent) {
        LogManager.i(TAG, "unbinding", new Object[0]);
        --this.bindCount;
        return false;
    }

    public void onCreate() {
        LogManager.i(TAG, "beaconService version %s is starting up", "2.3.5");
        this.bluetoothCrashResolver = new BluetoothCrashResolver((Context)this);
        this.bluetoothCrashResolver.start();
        this.mExecutor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() + 1);
        this.mCycledScanner = CycledLeScanner.createScanner((Context)this, 1100L, 0L, this.mBackgroundFlag, this.mCycledLeScanCallback, this.bluetoothCrashResolver);
        this.beaconParsers = BeaconManager.getInstanceForApplication(this.getApplicationContext()).getBeaconParsers();
        this.defaultDistanceCalculator = new ModelSpecificDistanceCalculator((Context)this, BeaconManager.getDistanceModelUpdateUrl());
        Beacon.setDistanceCalculator(this.defaultDistanceCalculator);
        try {
            Class<?> klass = Class.forName("org.altbeacon.beacon.SimulatedScanData");
            Field f = klass.getField("beacons");
            this.simulatedScanData = (List)f.get(null);
        }
        catch (ClassNotFoundException e) {
            LogManager.d(TAG, "No org.altbeacon.beacon.SimulatedScanData class exists.", new Object[0]);
        }
        catch (Exception e) {
            LogManager.e(e, TAG, "Cannot get simulated Scan data.  Make sure your org.altbeacon.beacon.SimulatedScanData class defines a field with the signature 'public static List<Beacon> beacons'", new Object[0]);
        }
    }

    @TargetApi(value=18)
    public void onDestroy() {
        if (Build.VERSION.SDK_INT < 18) {
            LogManager.w(TAG, "Not supported prior to API 18.", new Object[0]);
            return;
        }
        this.bluetoothCrashResolver.stop();
        LogManager.i(TAG, "onDestroy called.  stopping scanning", new Object[0]);
        this.handler.removeCallbacksAndMessages(null);
        this.mCycledScanner.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRangingBeaconsInRegion(Region region, Callback callback) {
        Map<Region, RangeState> map = this.rangedRegionState;
        synchronized (map) {
            if (this.rangedRegionState.containsKey(region)) {
                LogManager.i(TAG, "Already ranging that region -- will replace existing region.", new Object[0]);
                this.rangedRegionState.remove(region);
            }
            this.rangedRegionState.put(region, new RangeState(callback));
            LogManager.d(TAG, "Currently ranging %s regions.", this.rangedRegionState.size());
        }
        this.mCycledScanner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRangingBeaconsInRegion(Region region) {
        int rangedRegionCount;
        Map<Region, RangeState> map = this.rangedRegionState;
        synchronized (map) {
            this.rangedRegionState.remove(region);
            rangedRegionCount = this.rangedRegionState.size();
            LogManager.d(TAG, "Currently ranging %s regions.", this.rangedRegionState.size());
        }
        if (rangedRegionCount == 0 && this.monitoredRegionState.size() == 0) {
            this.mCycledScanner.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMonitoringBeaconsInRegion(Region region, Callback callback) {
        LogManager.d(TAG, "startMonitoring called", new Object[0]);
        Map<Region, MonitorState> map = this.monitoredRegionState;
        synchronized (map) {
            if (this.monitoredRegionState.containsKey(region)) {
                LogManager.i(TAG, "Already monitoring that region -- will replace existing region monitor.", new Object[0]);
                this.monitoredRegionState.remove(region);
            }
            this.monitoredRegionState.put(region, new MonitorState(callback));
        }
        LogManager.d(TAG, "Currently monitoring %s regions.", this.monitoredRegionState.size());
        this.mCycledScanner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMonitoringBeaconsInRegion(Region region) {
        int monitoredRegionCount;
        LogManager.d(TAG, "stopMonitoring called", new Object[0]);
        Map<Region, MonitorState> map = this.monitoredRegionState;
        synchronized (map) {
            this.monitoredRegionState.remove(region);
            monitoredRegionCount = this.monitoredRegionState.size();
        }
        LogManager.d(TAG, "Currently monitoring %s regions.", this.monitoredRegionState.size());
        if (monitoredRegionCount == 0 && this.rangedRegionState.size() == 0) {
            this.mCycledScanner.stop();
        }
    }

    public void setScanPeriods(long scanPeriod, long betweenScanPeriod, boolean backgroundFlag) {
        this.mCycledScanner.setScanPeriods(scanPeriod, betweenScanPeriod, backgroundFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRangeData() {
        Map<Region, RangeState> map = this.rangedRegionState;
        synchronized (map) {
            for (Region region : this.rangedRegionState.keySet()) {
                RangeState rangeState = this.rangedRegionState.get(region);
                LogManager.d(TAG, "Calling ranging callback", new Object[0]);
                rangeState.getCallback().call((Context)this, "rangingData", new RangingData(rangeState.finalizeBeacons(), region));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processExpiredMonitors() {
        Map<Region, MonitorState> map = this.monitoredRegionState;
        synchronized (map) {
            for (Region region : this.monitoredRegionState.keySet()) {
                MonitorState state = this.monitoredRegionState.get(region);
                if (!state.isNewlyOutside()) continue;
                LogManager.d(TAG, "found a monitor that expired: %s", region);
                state.getCallback().call((Context)this, "monitoringData", new MonitoringData(state.isInside(), region));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBeaconFromScan(Beacon beacon) {
        if (Stats.getInstance().isEnabled()) {
            Stats.getInstance().log(beacon);
        }
        ++this.trackedBeaconsPacketCount;
        if (LogManager.isVerboseLoggingEnabled()) {
            LogManager.d(TAG, "beacon detected : %s", beacon.toString());
        }
        if ((beacon = this.mGattBeaconTracker.track(beacon)) == null) {
            if (LogManager.isVerboseLoggingEnabled()) {
                LogManager.d(TAG, "not processing detections for GATT extra data beacon", new Object[0]);
            }
        } else {
            List<Region> matchedRegions = null;
            Map<Region, MonitorState> map = this.monitoredRegionState;
            synchronized (map) {
                matchedRegions = this.matchingRegions(beacon, this.monitoredRegionState.keySet());
            }
            for (Region region : matchedRegions) {
                MonitorState state = this.monitoredRegionState.get(region);
                if (state == null || !state.markInside()) continue;
                state.getCallback().call((Context)this, "monitoringData", new MonitoringData(state.isInside(), region));
            }
            LogManager.d(TAG, "looking for ranging region matches for this beacon", new Object[0]);
            Map<Region, RangeState> map2 = this.rangedRegionState;
            synchronized (map2) {
                matchedRegions = this.matchingRegions(beacon, this.rangedRegionState.keySet());
                for (Region region : matchedRegions) {
                    LogManager.d(TAG, "matches ranging region: %s", region);
                    RangeState rangeState = this.rangedRegionState.get(region);
                    if (rangeState == null) continue;
                    rangeState.addBeacon(beacon);
                }
            }
        }
    }

    private List<Region> matchingRegions(Beacon beacon, Collection<Region> regions) {
        ArrayList<Region> matched = new ArrayList<Region>();
        for (Region region : regions) {
            if (region == null) continue;
            if (region.matchesBeacon(beacon)) {
                matched.add(region);
                continue;
            }
            LogManager.d(TAG, "This region (%s) does not match beacon: %s", region, beacon);
        }
        return matched;
    }

    private class ScanProcessor
    extends AsyncTask<ScanData, Void, Void> {
        DetectionTracker mDetectionTracker = DetectionTracker.getInstance();

        private ScanProcessor() {
        }

        protected Void doInBackground(ScanData ... params) {
            BeaconParser parser;
            ScanData scanData = params[0];
            Beacon beacon = null;
            Iterator i$ = BeaconService.this.beaconParsers.iterator();
            while (i$.hasNext() && (beacon = (parser = (BeaconParser)i$.next()).fromScanData(scanData.scanRecord, scanData.rssi, scanData.device)) == null) {
            }
            if (beacon != null) {
                this.mDetectionTracker.recordDetection();
                BeaconService.this.processBeaconFromScan(beacon);
            }
            return null;
        }

        protected void onPostExecute(Void result) {
        }

        protected void onPreExecute() {
        }

        protected void onProgressUpdate(Void ... values) {
        }
    }

    private class ScanData {
        int rssi;
        BluetoothDevice device;
        byte[] scanRecord;

        public ScanData(BluetoothDevice device, int rssi, byte[] scanRecord) {
            this.device = device;
            this.rssi = rssi;
            this.scanRecord = scanRecord;
        }
    }

    static class IncomingHandler
    extends Handler {
        private final WeakReference<BeaconService> mService;

        IncomingHandler(BeaconService service) {
            this.mService = new WeakReference<BeaconService>(service);
        }

        public void handleMessage(Message msg) {
            BeaconService service = (BeaconService)((Object)this.mService.get());
            StartRMData startRMData = (StartRMData)msg.obj;
            if (service != null) {
                switch (msg.what) {
                    case 2: {
                        LogManager.i(BeaconService.TAG, "start ranging received", new Object[0]);
                        service.startRangingBeaconsInRegion(startRMData.getRegionData(), new Callback(startRMData.getCallbackPackageName()));
                        service.setScanPeriods(startRMData.getScanPeriod(), startRMData.getBetweenScanPeriod(), startRMData.getBackgroundFlag());
                        break;
                    }
                    case 3: {
                        LogManager.i(BeaconService.TAG, "stop ranging received", new Object[0]);
                        service.stopRangingBeaconsInRegion(startRMData.getRegionData());
                        service.setScanPeriods(startRMData.getScanPeriod(), startRMData.getBetweenScanPeriod(), startRMData.getBackgroundFlag());
                        break;
                    }
                    case 4: {
                        LogManager.i(BeaconService.TAG, "start monitoring received", new Object[0]);
                        service.startMonitoringBeaconsInRegion(startRMData.getRegionData(), new Callback(startRMData.getCallbackPackageName()));
                        service.setScanPeriods(startRMData.getScanPeriod(), startRMData.getBetweenScanPeriod(), startRMData.getBackgroundFlag());
                        break;
                    }
                    case 5: {
                        LogManager.i(BeaconService.TAG, "stop monitoring received", new Object[0]);
                        service.stopMonitoringBeaconsInRegion(startRMData.getRegionData());
                        service.setScanPeriods(startRMData.getScanPeriod(), startRMData.getBetweenScanPeriod(), startRMData.getBackgroundFlag());
                        break;
                    }
                    case 6: {
                        LogManager.i(BeaconService.TAG, "set scan intervals received", new Object[0]);
                        service.setScanPeriods(startRMData.getScanPeriod(), startRMData.getBetweenScanPeriod(), startRMData.getBackgroundFlag());
                        break;
                    }
                    default: {
                        super.handleMessage(msg);
                    }
                }
            }
        }
    }

    public class BeaconBinder
    extends Binder {
        public BeaconService getService() {
            LogManager.i(BeaconService.TAG, "getService of BeaconBinder called", new Object[0]);
            return BeaconService.this;
        }
    }
}

