/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.utils;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UrlBeaconUrlCompressor {
    private static final String EDDYSTONE_URL_REGEX = "^(http|https):\\/\\/(www\\.)?((?:[0-9a-z_-]+\\.?)+)(/?)([./0-9a-z_-]*)";
    private static final int EDDYSTONE_URL_PROTOCOL_GROUP = 1;
    private static final int EDDYSTONE_URL_WWW_GROUP = 2;
    private static final int EDDYSTONE_URL_FQDN_GROUP = 3;
    private static final int EDDYSTONE_URL_SLASH_GROUP = 4;
    private static final int EDDYSTONE_URL_PATH_GROUP = 5;
    private static final String URL_PROTOCOL_HTTP_WWW_DOT = "http://www.";
    private static final String URL_PROTOCOL_HTTPS_WWW_DOT = "https://www.";
    private static final String URL_PROTOCOL_HTTP = "http";
    private static final String URL_PROTOCOL_HTTP_COLON_SLASH_SLASH = "http://";
    private static final String URL_PROTOCOL_HTTPS_COLON_SLASH_SLASH = "https://";
    private static final String URL_HOST_WWW = "www.";
    private static final String URL_TLD_DOT_COM = ".com";
    private static final String URL_TLD_DOT_ORG = ".org";
    private static final String URL_TLD_DOT_EDU = ".edu";
    private static final String URL_TLD_DOT_NET = ".net";
    private static final String URL_TLD_DOT_INFO = ".info";
    private static final String URL_TLD_DOT_BIZ = ".biz";
    private static final String URL_TLD_DOT_GOV = ".gov";
    private static final String URL_TLD_DOT_COM_SLASH = ".com/";
    private static final String URL_TLD_DOT_ORG_SLASH = ".org/";
    private static final String URL_TLD_DOT_EDU_SLASH = ".edu/";
    private static final String URL_TLD_DOT_NET_SLASH = ".net/";
    private static final String URL_TLD_DOT_INFO_SLASH = ".info/";
    private static final String URL_TLD_DOT_BIZ_SLASH = ".biz/";
    private static final String URL_TLD_DOT_GOV_SLASH = ".gov/";
    private static final byte EDDYSTONE_URL_PROTOCOL_HTTP_WWW = 0;
    private static final byte EDDYSTONE_URL_PROTOCOL_HTTPS_WWW = 1;
    private static final byte EDDYSTONE_URL_PROTOCOL_HTTP = 2;
    private static final byte EDDYSTONE_URL_PROTOCOL_HTTPS = 3;
    private static final byte EDDYSTONE_URL_COM_SLASH = 0;
    private static final byte EDDYSTONE_URL_ORG_SLASH = 1;
    private static final byte EDDYSTONE_URL_EDU_SLASH = 2;
    private static final byte EDDYSTONE_URL_NET_SLASH = 3;
    private static final byte EDDYSTONE_URL_INFO_SLASH = 4;
    private static final byte EDDYSTONE_URL_BIZ_SLASH = 5;
    private static final byte EDDYSTONE_URL_GOV_SLASH = 6;
    private static final byte EDDYSTONE_URL_COM = 7;
    private static final byte EDDYSTONE_URL_ORG = 8;
    private static final byte EDDYSTONE_URL_EDU = 9;
    private static final byte EDDYSTONE_URL_NET = 10;
    private static final byte EDDYSTONE_URL_INFO = 11;
    private static final byte EDDYSTONE_URL_BIZ = 12;
    private static final byte EDDYSTONE_URL_GOV = 13;
    private static final byte TLD_NOT_ENCODABLE = -1;
    private static List<TLDMapEntry> tldMap = new ArrayList<TLDMapEntry>();

    private static byte encodedByteForTopLevelDomain(String tld) {
        byte encodedByte = -1;
        boolean tldFound = false;
        Iterator<TLDMapEntry> iterator = tldMap.iterator();
        while (!tldFound && iterator.hasNext()) {
            TLDMapEntry entry = iterator.next();
            tldFound = entry.tld.equalsIgnoreCase(tld);
            if (!tldFound) continue;
            encodedByte = entry.encodedByte;
        }
        return encodedByte;
    }

    private static String topLevelDomainForByte(Byte encodedByte) {
        String tld = null;
        boolean tldFound = false;
        Iterator<TLDMapEntry> iterator = tldMap.iterator();
        while (!tldFound && iterator.hasNext()) {
            TLDMapEntry entry = iterator.next();
            tldFound = entry.encodedByte == encodedByte;
            if (!tldFound) continue;
            tld = entry.tld;
        }
        return tld;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] compress(String urlString) throws MalformedURLException {
        String path;
        String slash;
        byte[] compressedBytes = null;
        if (urlString == null) throw new MalformedURLException();
        byte[] byteBuffer = new byte[urlString.length()];
        int byteBufferIndex = 0;
        Arrays.fill(byteBuffer, (byte)0);
        Pattern urlPattern = Pattern.compile(EDDYSTONE_URL_REGEX);
        Matcher urlMatcher = urlPattern.matcher(urlString);
        if (!urlMatcher.matches()) throw new MalformedURLException();
        String wwwdot = urlMatcher.group(2);
        boolean haswww = wwwdot != null;
        String protocol = urlMatcher.group(1);
        byteBuffer[byteBufferIndex] = protocol.equalsIgnoreCase(URL_PROTOCOL_HTTP) ? (haswww ? 0 : 2) : (haswww ? 1 : 3);
        ++byteBufferIndex;
        byte[] hostnameBytes = urlMatcher.group(3).getBytes();
        String hostname = new String(hostnameBytes);
        String[] domains = hostname.split(Pattern.quote("."));
        boolean consumedSlash = false;
        if (domains != null) {
            byte[] periodBytes = new byte[]{46};
            int writableDomainsCount = domains.length == 1 ? 1 : domains.length - 1;
            for (int domainIndex = 0; domainIndex < writableDomainsCount; ++domainIndex) {
                if (domainIndex > 0) {
                    System.arraycopy(periodBytes, 0, byteBuffer, byteBufferIndex, periodBytes.length);
                    byteBufferIndex += periodBytes.length;
                }
                byte[] domainBytes = domains[domainIndex].getBytes();
                int domainLength = domainBytes.length;
                System.arraycopy(domainBytes, 0, byteBuffer, byteBufferIndex, domainLength);
                byteBufferIndex += domainLength;
            }
            if (domains.length > 1) {
                String tld = "." + domains[domains.length - 1];
                String slash2 = urlMatcher.group(4);
                String encodableTLDCandidate = slash2 == null ? tld : tld + slash2;
                byte encodedTLDByte = UrlBeaconUrlCompressor.encodedByteForTopLevelDomain(encodableTLDCandidate);
                if (encodedTLDByte != -1) {
                    byteBuffer[byteBufferIndex++] = encodedTLDByte;
                    consumedSlash = slash2 != null;
                } else {
                    byte[] tldBytes = tld.getBytes();
                    int tldLength = tldBytes.length;
                    System.arraycopy(tldBytes, 0, byteBuffer, byteBufferIndex, tldLength);
                    byteBufferIndex += tldLength;
                }
            }
        }
        if (!consumedSlash && (slash = urlMatcher.group(4)) != null) {
            int slashLength = slash.length();
            System.arraycopy(slash.getBytes(), 0, byteBuffer, byteBufferIndex, slashLength);
            byteBufferIndex += slashLength;
        }
        if ((path = urlMatcher.group(5)) != null) {
            int pathLength = path.length();
            System.arraycopy(path.getBytes(), 0, byteBuffer, byteBufferIndex, pathLength);
            byteBufferIndex += pathLength;
        }
        compressedBytes = new byte[byteBufferIndex];
        System.arraycopy(byteBuffer, 0, compressedBytes, 0, compressedBytes.length);
        return compressedBytes;
    }

    public static String uncompress(byte[] compressedURL) {
        StringBuffer url = new StringBuffer();
        switch (compressedURL[0] & 0xF) {
            case 0: {
                url.append(URL_PROTOCOL_HTTP_WWW_DOT);
                break;
            }
            case 1: {
                url.append(URL_PROTOCOL_HTTPS_WWW_DOT);
                break;
            }
            case 2: {
                url.append(URL_PROTOCOL_HTTP_COLON_SLASH_SLASH);
                break;
            }
            case 3: {
                url.append(URL_PROTOCOL_HTTPS_COLON_SLASH_SLASH);
                break;
            }
        }
        byte lastByte = -1;
        for (int i = 1; i < compressedURL.length; ++i) {
            byte b = compressedURL[i];
            if (lastByte == 0 && b == 0) break;
            lastByte = b;
            String tld = UrlBeaconUrlCompressor.topLevelDomainForByte(b);
            if (tld != null) {
                url.append(tld);
                continue;
            }
            url.append((char)b);
        }
        return url.toString();
    }

    static {
        tldMap.add(new TLDMapEntry(URL_TLD_DOT_COM_SLASH, 0));
        tldMap.add(new TLDMapEntry(URL_TLD_DOT_ORG_SLASH, 1));
        tldMap.add(new TLDMapEntry(URL_TLD_DOT_EDU_SLASH, 2));
        tldMap.add(new TLDMapEntry(URL_TLD_DOT_NET_SLASH, 3));
        tldMap.add(new TLDMapEntry(URL_TLD_DOT_INFO_SLASH, 4));
        tldMap.add(new TLDMapEntry(URL_TLD_DOT_BIZ_SLASH, 5));
        tldMap.add(new TLDMapEntry(URL_TLD_DOT_GOV_SLASH, 6));
        tldMap.add(new TLDMapEntry(URL_TLD_DOT_COM, 7));
        tldMap.add(new TLDMapEntry(URL_TLD_DOT_ORG, 8));
        tldMap.add(new TLDMapEntry(URL_TLD_DOT_EDU, 9));
        tldMap.add(new TLDMapEntry(URL_TLD_DOT_NET, 10));
        tldMap.add(new TLDMapEntry(URL_TLD_DOT_INFO, 11));
        tldMap.add(new TLDMapEntry(URL_TLD_DOT_BIZ, 12));
        tldMap.add(new TLDMapEntry(URL_TLD_DOT_GOV, 13));
    }

    private static class TLDMapEntry {
        public final String tld;
        public final byte encodedByte;

        public TLDMapEntry(String topLevelDomain, byte encodedTLDByte) {
            this.tld = topLevelDomain;
            this.encodedByte = encodedTLDByte;
        }
    }
}

