/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service;

import android.content.Context;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.Region;
import org.altbeacon.beacon.logging.LogManager;
import org.altbeacon.beacon.service.Callback;
import org.altbeacon.beacon.service.MonitoringData;
import org.altbeacon.beacon.service.RegionMonitoringState;

public class MonitoringStatus {
    private static MonitoringStatus sInstance;
    private static final String TAG;
    public static final String STATUS_PRESERVATION_FILE_NAME = "org.altbeacon.beacon.service.monitoring_status_state";
    private final Map<Region, RegionMonitoringState> mRegionsStatesMap = new HashMap<Region, RegionMonitoringState>();
    private Context mContext;
    private boolean mStatePreservationIsOn = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MonitoringStatus getInstanceForApplication(Context context) {
        if (sInstance != null) return sInstance;
        Class<MonitoringStatus> clazz = MonitoringStatus.class;
        synchronized (MonitoringStatus.class) {
            if (sInstance != null) return sInstance;
            sInstance = new MonitoringStatus(context.getApplicationContext());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    public MonitoringStatus(Context context) {
        this.mContext = context;
        this.restoreMonitoringStatus();
    }

    public synchronized void addRegion(Region region) {
        if (this.mRegionsStatesMap.containsKey(region)) {
            return;
        }
        this.mRegionsStatesMap.put(region, new RegionMonitoringState(new Callback(this.mContext.getPackageName())));
        this.saveMonitoringStatusIfOn();
    }

    public synchronized void removeRegion(Region region) {
        this.mRegionsStatesMap.remove(region);
        this.saveMonitoringStatusIfOn();
    }

    public synchronized Set<Region> regions() {
        return this.mRegionsStatesMap.keySet();
    }

    public synchronized int regionsCount() {
        return this.regions().size();
    }

    public synchronized RegionMonitoringState stateOf(Region region) {
        return this.mRegionsStatesMap.get(region);
    }

    public synchronized void updateNewlyOutside() {
        Iterator<Region> monitoredRegionIterator = this.regions().iterator();
        boolean needsMonitoringStateSaving = false;
        while (monitoredRegionIterator.hasNext()) {
            Region region = monitoredRegionIterator.next();
            RegionMonitoringState state = this.stateOf(region);
            if (!state.isNewlyOutside()) continue;
            needsMonitoringStateSaving = true;
            LogManager.d(TAG, "found a monitor that expired: %s", region);
            state.getCallback().call(this.mContext, "monitoringData", new MonitoringData(state.isInside(), region));
        }
        if (needsMonitoringStateSaving) {
            this.saveMonitoringStatusIfOn();
        }
    }

    public synchronized void updateNewlyInsideInRegionsContaining(Beacon beacon) {
        List<Region> matchingRegions = this.regionsMatchingTo(beacon);
        boolean needsMonitoringStateSaving = false;
        for (Region region : matchingRegions) {
            RegionMonitoringState state = this.mRegionsStatesMap.get(region);
            if (state == null || !state.markInside()) continue;
            needsMonitoringStateSaving = true;
            state.getCallback().call(this.mContext, "monitoringData", new MonitoringData(state.isInside(), region));
        }
        if (needsMonitoringStateSaving) {
            this.saveMonitoringStatusIfOn();
        }
    }

    private List<Region> regionsMatchingTo(Beacon beacon) {
        ArrayList<Region> matched = new ArrayList<Region>();
        for (Region region : this.regions()) {
            if (region.matchesBeacon(beacon)) {
                matched.add(region);
                continue;
            }
            LogManager.d(TAG, "This region (%s) does not match beacon: %s", region, beacon);
        }
        return matched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveMonitoringStatusIfOn() {
        if (!this.mStatePreservationIsOn) {
            return;
        }
        LogManager.d(TAG, "saveMonitoringStatusIfOn()", new Object[0]);
        FileOutputStream outputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            outputStream = this.mContext.openFileOutput(STATUS_PRESERVATION_FILE_NAME, 0);
            objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(this.mRegionsStatesMap);
        }
        catch (IOException e) {
            LogManager.e(TAG, "Error while saving monitored region states to file. %s ", e.getMessage());
        }
        finally {
            if (null != outputStream) {
                try {
                    outputStream.close();
                }
                catch (IOException ignored) {}
            }
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreMonitoringStatus() {
        FileInputStream inputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            inputStream = this.mContext.openFileInput(STATUS_PRESERVATION_FILE_NAME);
            objectInputStream = new ObjectInputStream(inputStream);
            Map obj = (Map)objectInputStream.readObject();
            this.mRegionsStatesMap.putAll(obj);
        }
        catch (IOException | ClassCastException | ClassNotFoundException e) {
            if (e instanceof InvalidClassException) {
                LogManager.d(TAG, "Serialized Monitoring State has wrong class. Just ignoring saved state...", new Object[0]);
            } else {
                LogManager.e(TAG, "Deserialization exception, message: $s", e.getMessage());
            }
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException ignored) {}
            }
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public synchronized void stopStatusPreservationOnProcessDestruction() {
        this.mContext.deleteFile(STATUS_PRESERVATION_FILE_NAME);
        this.mStatePreservationIsOn = false;
    }

    public synchronized void clear() {
        this.mContext.deleteFile(STATUS_PRESERVATION_FILE_NAME);
        this.mRegionsStatesMap.clear();
    }

    static {
        TAG = MonitoringStatus.class.getSimpleName();
    }
}

