/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service;

import java.util.HashMap;
import org.altbeacon.beacon.Beacon;

public class ExtraDataBeaconTracker {
    private static final String TAG = "BeaconTracker";
    private HashMap<String, HashMap<Integer, Beacon>> mBeaconsByKey = new HashMap();
    private boolean matchBeaconsByServiceUUID = true;

    public ExtraDataBeaconTracker() {
    }

    public ExtraDataBeaconTracker(boolean matchBeaconsByServiceUUID) {
        this.matchBeaconsByServiceUUID = matchBeaconsByServiceUUID;
    }

    public synchronized Beacon track(Beacon beacon) {
        Beacon trackedBeacon = null;
        trackedBeacon = beacon.isMultiFrameBeacon() || beacon.getServiceUuid() != -1 ? this.trackGattBeacon(beacon) : beacon;
        return trackedBeacon;
    }

    private Beacon trackGattBeacon(Beacon beacon) {
        Beacon trackedBeacon = null;
        HashMap<Integer, Beacon> matchingTrackedBeacons = this.mBeaconsByKey.get(this.getBeaconKey(beacon));
        if (matchingTrackedBeacons != null) {
            for (Beacon matchingTrackedBeacon : matchingTrackedBeacons.values()) {
                if (beacon.isExtraBeaconData()) {
                    matchingTrackedBeacon.setRssi(beacon.getRssi());
                    matchingTrackedBeacon.setExtraDataFields(beacon.getDataFields());
                    continue;
                }
                beacon.setExtraDataFields(matchingTrackedBeacon.getExtraDataFields());
                trackedBeacon = beacon;
            }
        }
        if (!beacon.isExtraBeaconData()) {
            this.updateTrackingHashes(beacon, matchingTrackedBeacons);
        }
        if (trackedBeacon == null && !beacon.isExtraBeaconData()) {
            trackedBeacon = beacon;
        }
        return trackedBeacon;
    }

    private void updateTrackingHashes(Beacon trackedBeacon, HashMap<Integer, Beacon> matchingTrackedBeacons) {
        if (matchingTrackedBeacons == null) {
            matchingTrackedBeacons = new HashMap();
        }
        matchingTrackedBeacons.put(trackedBeacon.hashCode(), trackedBeacon);
        this.mBeaconsByKey.put(this.getBeaconKey(trackedBeacon), matchingTrackedBeacons);
    }

    private String getBeaconKey(Beacon beacon) {
        if (this.matchBeaconsByServiceUUID) {
            return beacon.getBluetoothAddress() + beacon.getServiceUuid();
        }
        return beacon.getBluetoothAddress();
    }
}

