/*
 * Decompiled with CFR 0.152.
 */
package org.amplecode.staxwax.reader;

import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.amplecode.staxwax.XMLException;
import org.amplecode.staxwax.reader.XMLReader;

public class DefaultXMLStreamReader
implements XMLReader {
    private XMLStreamReader reader;

    public DefaultXMLStreamReader(XMLStreamReader reader) {
        this.reader = reader;
    }

    @Override
    public String getElementName() {
        int eventType = this.reader.getEventType();
        return eventType == 1 || eventType == 2 ? this.reader.getLocalName() : null;
    }

    @Override
    public String getElementValue() {
        try {
            this.reader.next();
            return this.getText();
        }
        catch (XMLStreamException ex) {
            throw new XMLException("Failed to get element value", ex);
        }
    }

    @Override
    public void moveToStartElement(String name) {
        try {
            while (!(this.reader.next() == 8 || this.reader.getEventType() == 1 && this.reader.getLocalName().equals(name))) {
            }
        }
        catch (XMLStreamException ex) {
            throw new XMLException("Failed to move to start element", ex);
        }
    }

    @Override
    public boolean moveToStartElement(String startElementName, String endElementName) {
        try {
            while (this.reader.next() != 8) {
                if (this.reader.getEventType() == 1 && this.reader.getLocalName().equals(startElementName)) {
                    return true;
                }
                if (this.reader.getEventType() != 2 || !this.reader.getLocalName().equals(endElementName)) continue;
                return false;
            }
            return false;
        }
        catch (XMLStreamException ex) {
            throw new XMLException("Failed to move to start element", ex);
        }
    }

    @Override
    public boolean isStartElement(String name) {
        return this.reader.getEventType() == 1 && this.reader.getLocalName().equals(name);
    }

    @Override
    public boolean isEndElement(String name) {
        return this.reader.getEventType() == 2 && this.reader.getLocalName().equals(name);
    }

    @Override
    public boolean next() {
        try {
            return this.reader.next() != 8;
        }
        catch (XMLStreamException ex) {
            throw new XMLException("Failed to move cursor to next element", ex);
        }
    }

    @Override
    public boolean next(String endElementName) {
        try {
            return this.reader.next() != 2 || !this.reader.getLocalName().equals(endElementName);
        }
        catch (XMLStreamException ex) {
            throw new XMLException("Failed to move cursor to next element", ex);
        }
    }

    @Override
    public String getAttributeValue(String attributeName) {
        return this.nullIfEmpty(this.reader.getAttributeValue(null, attributeName));
    }

    @Override
    public int getAttributeCount() {
        return this.reader.getAttributeCount();
    }

    @Override
    public Map<String, String> readElements(String elementName) {
        try {
            HashMap<String, String> elements = new HashMap<String, String>();
            String currentElementName = null;
            while (this.reader.hasNext() && (this.reader.getEventType() != 2 || !this.reader.getLocalName().equals(elementName))) {
                if (this.reader.getEventType() == 1) {
                    for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
                        elements.put(this.reader.getAttributeLocalName(i), this.nullIfEmpty(this.reader.getAttributeValue(i)));
                    }
                    currentElementName = this.reader.getLocalName();
                    this.reader.next();
                    elements.put(currentElementName, this.getText());
                    continue;
                }
                this.reader.next();
            }
            return elements;
        }
        catch (XMLStreamException ex) {
            throw new XMLException("Failed to read elements", ex);
        }
    }

    @Override
    public XMLStreamReader getXmlStreamReader() {
        return this.reader;
    }

    @Override
    public void closeReader() {
        try {
            this.reader.close();
        }
        catch (XMLStreamException ex) {
            throw new XMLException("Failed to close reader", ex);
        }
    }

    protected String getText() throws XMLStreamException {
        StringBuffer sb = new StringBuffer();
        while (this.reader.isCharacters() || this.reader.getEventType() == 12) {
            sb.append(this.reader.getText());
            this.reader.next();
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    private String nullIfEmpty(String value) {
        return value != null && value.isEmpty() ? null : value;
    }
}

