/*
 * Decompiled with CFR 0.152.
 */
package org.amplecode.staxwax.writer;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.amplecode.staxwax.XMLException;
import org.amplecode.staxwax.writer.XMLWriter;

public class DefaultXMLStreamWriter
implements XMLWriter {
    private XMLStreamWriter writer;

    public DefaultXMLStreamWriter(XMLStreamWriter writer) {
        this.writer = writer;
    }

    @Override
    public void openDocument() {
        this.openDocument("UTF-8", "1.0");
    }

    @Override
    public void openDocument(String encoding, String version) {
        try {
            this.writer.writeStartDocument(encoding, version);
        }
        catch (XMLStreamException ex) {
            throw new XMLException("Failed to open document", ex);
        }
    }

    @Override
    public void openElement(String name) {
        try {
            this.writer.writeStartElement(this.verifyNotNull(name));
        }
        catch (XMLStreamException ex) {
            throw new XMLException("Failed to open element: " + name, ex);
        }
    }

    @Override
    public void openElement(String name, String ... attributeNameValuePairs) {
        try {
            this.writer.writeStartElement(this.verifyNotNull(name));
            if (attributeNameValuePairs.length % 2 == 0) {
                for (int i = 0; i < attributeNameValuePairs.length; i += 2) {
                    if (attributeNameValuePairs[i + 1] == null) continue;
                    this.writer.writeAttribute(this.verifyNotNull(attributeNameValuePairs[i]), attributeNameValuePairs[i + 1]);
                }
            }
        }
        catch (XMLStreamException ex) {
            throw new XMLException("Failed to open element: " + name, ex);
        }
    }

    @Override
    public void writeAttribute(String name, String value) {
        try {
            if (value != null) {
                this.writer.writeAttribute(this.verifyNotNull(name), value);
            }
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException("Failed to write attribute: " + name, ex);
        }
    }

    @Override
    public void writeElement(String name, String value) {
        try {
            this.writer.writeStartElement(this.verifyNotNull(name));
            this.writer.writeCharacters(this.replaceNull(value));
            this.writer.writeEndElement();
        }
        catch (XMLStreamException ex) {
            throw new XMLException("Failed to write element: " + name + ", value: " + value, ex);
        }
    }

    @Override
    public void writeElement(String name, String value, String ... attributeNameValuePairs) {
        try {
            this.writer.writeStartElement(this.verifyNotNull(name));
            if (attributeNameValuePairs.length % 2 == 0) {
                for (int i = 0; i < attributeNameValuePairs.length; i += 2) {
                    if (attributeNameValuePairs[i + 1] == null) continue;
                    this.writer.writeAttribute(this.verifyNotNull(attributeNameValuePairs[i]), attributeNameValuePairs[i + 1]);
                }
            }
            this.writer.writeCharacters(this.replaceNull(value));
            this.writer.writeEndElement();
        }
        catch (XMLStreamException ex) {
            throw new XMLException("Failed to write element: " + name + ", value: " + value, ex);
        }
    }

    @Override
    public void writeCharacters(String characters) {
        try {
            this.writer.writeCharacters(this.replaceNull(characters));
        }
        catch (XMLStreamException ex) {
            throw new XMLException("Failed to write characters: " + characters, ex);
        }
    }

    @Override
    public void writeCData(String cData) {
        try {
            this.writer.writeCData(this.replaceNull(cData));
        }
        catch (XMLStreamException ex) {
            throw new XMLException("Failed to write CData: " + cData, ex);
        }
    }

    @Override
    public XMLStreamWriter getXmlStreamWriter() {
        return this.writer;
    }

    @Override
    public void closeElement() {
        try {
            this.writer.writeEndElement();
        }
        catch (XMLStreamException ex) {
            throw new XMLException("Failed to close element", ex);
        }
    }

    @Override
    public void closeDocument() {
        try {
            this.writer.writeEndDocument();
            this.writer.flush();
            this.writer.close();
        }
        catch (XMLStreamException ex) {
            throw new XMLException("Failed to close document", ex);
        }
    }

    @Override
    public void closeWriter() {
        try {
            this.writer.flush();
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
        try {
            this.writer.close();
        }
        catch (XMLStreamException ex) {
            throw new XMLException("Failed to close writer", ex);
        }
    }

    private String replaceNull(String string) {
        return string != null ? string : "";
    }

    private String verifyNotNull(String string) {
        if (string == null) {
            throw new XMLException("XML element or attribute can not be null");
        }
        return string;
    }
}

