/*
 * Decompiled with CFR 0.152.
 */
package org.amqphub.spring.boot.jms.autoconfigure;

import java.time.Duration;
import java.util.List;
import org.messaginghub.pooled.jms.JmsPoolConnectionFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="amqphub.amqp10jms")
public class AMQP10JMSProperties {
    private String remoteUrl = "amqp://localhost:5672";
    private String username;
    private String password;
    private String clientId;
    private boolean receiveLocalOnly = false;
    private boolean receiveNoWaitLocalOnly = false;
    private final DeserializationPolicy deserializationPolicy = new DeserializationPolicy();
    private Pool pool = new Pool();

    public String getRemoteUrl() {
        return this.remoteUrl;
    }

    public void setRemoteUrl(String remoteUrl) {
        this.remoteUrl = remoteUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public boolean isReceiveLocalOnly() {
        return this.receiveLocalOnly;
    }

    public void setReceiveLocalOnly(boolean receiveLocalOnly) {
        this.receiveLocalOnly = receiveLocalOnly;
    }

    public boolean isReceiveNoWaitLocalOnly() {
        return this.receiveNoWaitLocalOnly;
    }

    public void setReceiveNoWaitLocalOnly(boolean receiveNoWaitLocalOnly) {
        this.receiveNoWaitLocalOnly = receiveNoWaitLocalOnly;
    }

    public DeserializationPolicy getDeserializationPolicy() {
        return this.deserializationPolicy;
    }

    public Pool getPool() {
        return this.pool;
    }

    public void setPool(Pool pool) {
        this.pool = pool;
    }

    public static class Pool {
        private boolean enabled;
        private boolean blockIfSessionPoolIsFull = true;
        private Duration blockIfSessionPoolIsFullTimeout = Duration.ofMillis(-1L);
        private Duration connectionIdleTimeout = Duration.ofSeconds(30L);
        private int maxConnections = 1;
        private int maxSessionsPerConnection = 500;
        private Duration connectionCheckInterval = Duration.ofMillis(-1L);
        private boolean useAnonymousProducers = true;
        private int explicitProducerCacheSize = 0;
        private boolean useProviderJMSContext = false;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isBlockIfSessionPoolIsFull() {
            return this.blockIfSessionPoolIsFull;
        }

        public void setBlockIfSessionPoolIsFull(boolean blockIfSessionPoolIsFull) {
            this.blockIfSessionPoolIsFull = blockIfSessionPoolIsFull;
        }

        public Duration getBlockIfSessionPoolIsFullTimeout() {
            return this.blockIfSessionPoolIsFullTimeout;
        }

        public void setBlockIfSessionPoolIsFullTimeout(long blockIfSessionPoolIsFullTimeout) {
            this.blockIfSessionPoolIsFullTimeout = Duration.ofMillis(blockIfSessionPoolIsFullTimeout);
        }

        public Duration getConnectionIdleTimeout() {
            return this.connectionIdleTimeout;
        }

        public void setConnectionIdleTimeout(long connectionIdleTimeout) {
            this.connectionIdleTimeout = Duration.ofMillis(connectionIdleTimeout);
        }

        public int getMaxConnections() {
            return this.maxConnections;
        }

        public void setMaxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
        }

        public int getMaxSessionsPerConnection() {
            return this.maxSessionsPerConnection;
        }

        public void setMaxSessionsPerConnection(int maxSessionPerConnection) {
            this.maxSessionsPerConnection = maxSessionPerConnection;
        }

        public Duration getConnectionCheckInterval() {
            return this.connectionCheckInterval;
        }

        public void setConnectionCheckInterval(long connectionCheckInterval) {
            this.connectionCheckInterval = Duration.ofMillis(connectionCheckInterval);
        }

        public boolean isUseAnonymousProducers() {
            return this.useAnonymousProducers;
        }

        public void setUseAnonymousProducers(boolean useAnonymousProducers) {
            this.useAnonymousProducers = useAnonymousProducers;
        }

        public boolean isUseProviderJMSContext() {
            return this.useProviderJMSContext;
        }

        public void setUseProviderJMSContext(boolean useProviderJMSContext) {
            this.useProviderJMSContext = useProviderJMSContext;
        }

        public int getExplicitProducerCacheSize() {
            return this.explicitProducerCacheSize;
        }

        public void setExplicitProducerCacheSize(int explicitProducerCacheSize) {
            this.explicitProducerCacheSize = explicitProducerCacheSize;
        }

        public void configurePooledFactory(JmsPoolConnectionFactory factory) {
            factory.setBlockIfSessionPoolIsFull(this.isBlockIfSessionPoolIsFull());
            if (this.getBlockIfSessionPoolIsFullTimeout() != null) {
                factory.setBlockIfSessionPoolIsFullTimeout(this.getBlockIfSessionPoolIsFullTimeout().toMillis());
            }
            if (this.getConnectionCheckInterval() != null) {
                factory.setConnectionCheckInterval(this.getConnectionCheckInterval().toMillis());
            }
            if (this.getConnectionIdleTimeout() != null) {
                factory.setConnectionIdleTimeout((int)this.getConnectionIdleTimeout().toMillis());
            }
            factory.setExplicitProducerCacheSize(this.getExplicitProducerCacheSize());
            factory.setMaxConnections(this.getMaxConnections());
            factory.setMaxSessionsPerConnection(this.getMaxSessionsPerConnection());
            factory.setUseAnonymousProducers(this.isUseAnonymousProducers());
            factory.setUseProviderJMSContext(this.isUseProviderJMSContext());
        }
    }

    public static class DeserializationPolicy {
        private List<String> whiteList;
        private List<String> blackList;

        public List<String> getWhiteList() {
            return this.whiteList;
        }

        public void setWhiteList(List<String> whiteList) {
            this.whiteList = whiteList;
        }

        public List<String> getBlackList() {
            return this.blackList;
        }

        public void setBlackList(List<String> blackList) {
            this.blackList = blackList;
        }
    }
}

