/*
 * Decompiled with CFR 0.152.
 */
package org.amqphub.spring.boot.jms.autoconfigure;

import jakarta.jms.ConnectionFactory;
import org.amqphub.spring.boot.jms.autoconfigure.AMQP10JMSConnectionFactoryCustomizer;
import org.amqphub.spring.boot.jms.autoconfigure.AMQP10JMSConnectionFactoryFactory;
import org.amqphub.spring.boot.jms.autoconfigure.AMQP10JMSProperties;
import org.apache.commons.pool2.PooledObject;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.messaginghub.pooled.jms.JmsPoolConnectionFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jms.JmsPoolConnectionFactoryFactory;
import org.springframework.boot.autoconfigure.jms.JmsPoolConnectionFactoryProperties;
import org.springframework.boot.autoconfigure.jms.JmsProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.connection.CachingConnectionFactory;

@Configuration(proxyBeanMethods=false)
@ConditionalOnMissingBean(value={ConnectionFactory.class})
public class AMQP10JMSConnectionFactoryConfiguration {
    private static JmsConnectionFactory createQpidJMSConnectionFactory(AMQP10JMSProperties properties, ObjectProvider<AMQP10JMSConnectionFactoryCustomizer> factoryCustomizers) {
        return new AMQP10JMSConnectionFactoryFactory(properties, factoryCustomizers).createConnectionFactory(JmsConnectionFactory.class);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={JmsPoolConnectionFactory.class, PooledObject.class})
    @ConditionalOnProperty(prefix="amqphub.amqp10jms.pool", name={"enabled"}, havingValue="true")
    static class PooledConnectionFactoryConfiguration {
        PooledConnectionFactoryConfiguration() {
        }

        @Bean(destroyMethod="stop")
        JmsPoolConnectionFactory jmsConnectionFactory(AMQP10JMSProperties properties, ObjectProvider<AMQP10JMSConnectionFactoryCustomizer> factoryCustomizers, JmsProperties jmsProperties) {
            JmsConnectionFactory connectionFactory = AMQP10JMSConnectionFactoryConfiguration.createQpidJMSConnectionFactory(properties, factoryCustomizers);
            JmsPoolConnectionFactory poolCf = new JmsPoolConnectionFactoryFactory((JmsPoolConnectionFactoryProperties)properties.getPool()).createPooledConnectionFactory((ConnectionFactory)connectionFactory);
            poolCf.setUseProviderJMSContext(properties.getPool().isUseProviderJMSContext());
            poolCf.setExplicitProducerCacheSize(properties.getPool().getExplicitProducerCacheSize());
            return poolCf;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={CachingConnectionFactory.class})
    @ConditionalOnProperty(prefix="amqphub.amqp10jms.pool", name={"enabled"}, havingValue="false", matchIfMissing=true)
    static class SimpleConnectionFactoryConfiguration {
        SimpleConnectionFactoryConfiguration() {
        }

        @Bean(name={"jmsConnectionFactory"})
        @ConditionalOnProperty(prefix="spring.jms.cache", name={"enabled"}, havingValue="true", matchIfMissing=true)
        CachingConnectionFactory cachingJmsConnectionFactory(AMQP10JMSProperties properties, ObjectProvider<AMQP10JMSConnectionFactoryCustomizer> factoryCustomizers, JmsProperties jmsProperties) {
            JmsProperties.Cache cacheProperties = jmsProperties.getCache();
            CachingConnectionFactory connectionFactory = new CachingConnectionFactory((ConnectionFactory)AMQP10JMSConnectionFactoryConfiguration.createQpidJMSConnectionFactory(properties, factoryCustomizers));
            connectionFactory.setCacheConsumers(cacheProperties.isConsumers());
            connectionFactory.setCacheProducers(cacheProperties.isProducers());
            connectionFactory.setSessionCacheSize(cacheProperties.getSessionCacheSize());
            return connectionFactory;
        }

        @Bean(name={"jmsConnectionFactory"})
        @ConditionalOnProperty(prefix="spring.jms.cache", name={"enabled"}, havingValue="false", matchIfMissing=false)
        JmsConnectionFactory jmsConnectionFactory(AMQP10JMSProperties properties, ObjectProvider<AMQP10JMSConnectionFactoryCustomizer> factoryCustomizers, JmsProperties jmsProperties) {
            return AMQP10JMSConnectionFactoryConfiguration.createQpidJMSConnectionFactory(properties, factoryCustomizers);
        }
    }
}

