/*
 * Decompiled with CFR 0.152.
 */
package org.analogweb.guice;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.TypeLiteral;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.analogweb.ContainerAdaptor;
import org.analogweb.guice.GuicePluginModulesConfig;
import org.analogweb.util.Assertion;
import org.analogweb.util.logging.Log;
import org.analogweb.util.logging.Logs;

public class GuiceContainerAdaptor
implements ContainerAdaptor {
    private static final Log log = Logs.getLog(GuiceContainerAdaptor.class);
    private final Injector injector;

    public GuiceContainerAdaptor(Injector injector) {
        Assertion.notNull((Object)injector, (String)Injector.class.getName());
        this.injector = injector;
    }

    public <T> T getInstanceOfType(Class<T> type) {
        Injector injector = this.getInjector();
        List<Binding<T>> bindings = this.findBindings(type, injector);
        if (bindings.isEmpty()) {
            return null;
        }
        Object instance = injector.getInstance(bindings.get(0).getKey());
        log.log(GuicePluginModulesConfig.PLUGIN_MESSAGE_RESOURCE, "DGB000001", new Object[]{type, instance, String.valueOf(injector.hashCode())});
        return (T)instance;
    }

    public <T> List<T> getInstancesOfType(Class<T> type) {
        Injector injector = this.getInjector();
        List<Binding<T>> findBindingsByType = this.findBindings(type, injector);
        ArrayList<Object> typeInstances = new ArrayList<Object>();
        for (Binding<T> binding : findBindingsByType) {
            Object instance = injector.getInstance(binding.getKey());
            typeInstances.add(instance);
        }
        log.log(GuicePluginModulesConfig.PLUGIN_MESSAGE_RESOURCE, "DGB000001", new Object[]{type, typeInstances, injector});
        return Collections.unmodifiableList(typeInstances);
    }

    private <T> List<Binding<T>> findBindings(Class<T> type, Injector injector) {
        TypeLiteral typeLiteral = TypeLiteral.get(type);
        return injector.findBindingsByType(typeLiteral);
    }

    protected Injector getInjector() {
        return this.injector;
    }
}

