/*
 * Decompiled with CFR 0.152.
 */
package org.analogweb.thymeleaf;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.analogweb.RequestContext;
import org.analogweb.ResponseContext;
import org.analogweb.ResponseFormatter;
import org.analogweb.core.FormatFailureException;
import org.analogweb.core.response.Html;
import org.analogweb.thymeleaf.ThymeleafPluginModulesConfig;
import org.analogweb.util.logging.Log;
import org.analogweb.util.logging.Logs;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.TemplateResolver;

public class ThymeleafHtmlFormatter
implements ResponseFormatter {
    private static final Log log = Logs.getLog(ThymeleafHtmlFormatter.class);
    private TemplateEngine engine;

    protected TemplateEngine initDefaultTemplateEngine() {
        TemplateEngine engine = new TemplateEngine();
        engine.setTemplateResolver((ITemplateResolver)this.createDefaultTemplateResolver());
        return engine;
    }

    protected TemplateResolver createDefaultTemplateResolver() {
        ClassLoaderTemplateResolver resolver = new ClassLoaderTemplateResolver();
        resolver.setCacheTTLMs(Long.valueOf(360000L));
        resolver.setSuffix(".html");
        resolver.setCharacterEncoding("UTF-8");
        return resolver;
    }

    public ResponseContext.ResponseEntity formatAndWriteInto(RequestContext context, ResponseContext writeTo, String charset, Object source) throws FormatFailureException {
        if (source instanceof Html.HtmlTemplate) {
            final Html.HtmlTemplate templateSource = (Html.HtmlTemplate)source;
            final IContext iContext = this.createIContext(context, templateSource);
            log.log(ThymeleafPluginModulesConfig.PLUGIN_MESSAGE_RESOURCE, "DTYB000001", new Object[]{context});
            final TemplateEngine engine = this.getTemplateEngine();
            log.log(ThymeleafPluginModulesConfig.PLUGIN_MESSAGE_RESOURCE, "DTYB000002", new Object[]{engine});
            return new ResponseContext.ResponseEntity(){

                public void writeInto(OutputStream responseBody) throws IOException {
                    OutputStreamWriter writer = new OutputStreamWriter(responseBody);
                    engine.process(templateSource.getTemplateResource(), iContext, (Writer)writer);
                    writer.flush();
                }

                public long getContentLength() {
                    return -1L;
                }
            };
        }
        log.log(ThymeleafPluginModulesConfig.PLUGIN_MESSAGE_RESOURCE, "WTYB000001", new Object[]{Html.HtmlTemplate.class.getCanonicalName()});
        log.log(ThymeleafPluginModulesConfig.PLUGIN_MESSAGE_RESOURCE, "WTYB000002");
        return null;
    }

    protected TemplateEngine getTemplateEngine() {
        if (this.engine == null) {
            this.engine = this.initDefaultTemplateEngine();
        }
        return this.engine;
    }

    protected IContext createIContext(RequestContext request, Html.HtmlTemplate templateSource) {
        Context context = new Context();
        context.setVariables(templateSource.getContext());
        return context;
    }

    public void setTemplateEngine(TemplateEngine engine) {
        this.engine = engine;
    }
}

