/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.gradle.plugin.velocity;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.anarres.gradle.plugin.velocity.VelocityPluginExtension;
import org.anarres.gradle.plugin.velocity.VelocityTask;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;

public class VelocityPlugin
implements Plugin<Project> {
    public void apply(final Project project) {
        final VelocityPluginExtension extension = (VelocityPluginExtension)project.getExtensions().create("velocity", VelocityPluginExtension.class, new Object[0]);
        Task velocityVppTask = project.getTasks().create("velocityVpp", VelocityTask.class, (Action)new Action<VelocityTask>(){

            public void execute(VelocityTask task) {
                task.setDescription("Preprocesses velocity template files.");
                task.conventionMapping("inputDir", new Callable<File>(){

                    @Override
                    public File call() {
                        return project.file(extension.inputDir);
                    }
                });
                task.conventionMapping("includeDirs", new Callable<List<File>>(){

                    @Override
                    public List<File> call() {
                        List<Object> includeDirs = extension.includeDirs;
                        if (includeDirs == null) {
                            return null;
                        }
                        ArrayList<File> out = new ArrayList<File>();
                        for (Object includeDir : includeDirs) {
                            out.add(project.file(includeDir));
                        }
                        return out;
                    }
                });
                task.conventionMapping("outputDir", new Callable<File>(){

                    @Override
                    public File call() {
                        return project.file(extension.outputDir);
                    }
                });
                task.conventionMapping("contextValues", new Callable<Map<String, Object>>(){

                    @Override
                    public Map<String, Object> call() {
                        return extension.contextValues;
                    }
                });
            }
        });
        project.getTasks().getByName("compileJava").dependsOn(new Object[]{velocityVppTask});
        SourceSetContainer sourceSets = ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
        SourceSet mainSourceSet = (SourceSet)sourceSets.getByName("main");
        mainSourceSet.getJava().srcDir(extension.outputDir);
    }
}

