/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.gradle.plugin.velocity;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.log.SystemLogChute;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class VelocityTask
extends ConventionTask {
    private File inputDir;
    private File outputDir;
    private String filter = "**/*.java";
    private List<File> includeDirs;
    private Map<String, Object> contextValues;

    @InputDirectory
    @Nonnull
    public File getInputDir() {
        return this.inputDir;
    }

    public void setInputDir(@Nonnull File inputDir) {
        this.inputDir = inputDir;
    }

    @OutputDirectory
    @Nonnull
    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(@Nonnull File outputDir) {
        this.outputDir = outputDir;
    }

    @Input
    @Nonnull
    public String getFilter() {
        return this.filter;
    }

    public void setFilter(@CheckForNull String filter) {
        this.filter = filter;
    }

    @Input
    @Optional
    @CheckForNull
    public List<File> getIncludeDirs() {
        return this.includeDirs;
    }

    public void setIncludeDirs(@Nonnull List<File> includeDirs) {
        this.includeDirs = includeDirs;
    }

    @InputFiles
    @Nonnull
    private FileCollection _getIncludeFiles() {
        ConfigurableFileCollection files = this.getProject().files(new Object[0]);
        List<File> includeDirs = this.getIncludeDirs();
        if (includeDirs != null) {
            for (File f : includeDirs) {
                files = files.plus((FileCollection)this.getProject().fileTree((Object)f));
            }
        }
        return files;
    }

    @Input
    @Optional
    @CheckForNull
    public Map<String, Object> getContextValues() {
        return this.contextValues;
    }

    public void setContextValues(@Nonnull Map<String, Object> contextValues) {
        this.contextValues = contextValues;
    }

    private void setProperty(VelocityEngine engine, String name, Object value) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("VelocityEngine property: " + name + " = " + value);
        }
        engine.setProperty(name, value);
    }

    @TaskAction
    public void runVelocity() throws Exception {
        File inputDir = this.getInputDir();
        final File outputDir = this.getOutputDir();
        DefaultGroovyMethods.deleteDir((File)outputDir);
        outputDir.mkdirs();
        final VelocityEngine engine = new VelocityEngine();
        this.setProperty(engine, "runtime.log.logsystem.class", SystemLogChute.class.getName());
        this.setProperty(engine, "resource.loader", "file");
        this.setProperty(engine, "file.resource.loader.cache", "true");
        StringBuilder includeBuf = new StringBuilder();
        includeBuf.append(inputDir.getAbsolutePath());
        for (File includeDir : this.getIncludeDirs()) {
            includeBuf.append(", ");
            includeBuf.append(includeDir.getAbsolutePath());
        }
        this.setProperty(engine, "file.resource.loader.path", includeBuf.toString());
        ConfigurableFileTree inputFiles = this.getProject().fileTree((Object)inputDir);
        inputFiles.include(new String[]{this.getFilter()});
        inputFiles.visit((FileVisitor)new EmptyFileVisitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitFile(FileVisitDetails fvd) {
                try {
                    File outputFile = fvd.getRelativePath().getFile(outputDir);
                    if (VelocityTask.this.getLogger().isDebugEnabled()) {
                        VelocityTask.this.getLogger().debug("Preprocessing " + fvd.getFile() + " -> " + outputFile);
                    }
                    VelocityContext context = new VelocityContext();
                    Map<String, Object> contextValues = VelocityTask.this.getContextValues();
                    if (contextValues != null) {
                        for (Map.Entry<String, Object> e : contextValues.entrySet()) {
                            context.put(e.getKey(), e.getValue());
                        }
                    }
                    context.put("project", (Object)VelocityTask.this.getProject());
                    context.put("package", (Object)DefaultGroovyMethods.join((Object[])fvd.getRelativePath().getParent().getSegments(), (String)"."));
                    context.put("class", (Object)fvd.getRelativePath().getLastName().replaceFirst("\\.java$", ""));
                    FileReader reader = new FileReader(fvd.getFile());
                    try {
                        outputFile.getParentFile().mkdirs();
                        FileWriter writer = new FileWriter(outputFile);
                        try {
                            engine.evaluate((Context)context, (Writer)writer, fvd.getRelativePath().toString(), (Reader)reader);
                        }
                        finally {
                            writer.close();
                        }
                    }
                    finally {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    throw new GradleException("Failed to process " + fvd, (Throwable)e);
                }
            }
        });
    }
}

