/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.lzo.hadoop.codec;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.anarres.lzo.hadoop.codec.LzoCodec;
import org.anarres.lzo.hadoop.codec.LzoCompressor;
import org.anarres.lzo.hadoop.codec.LzopInputStream;
import org.anarres.lzo.hadoop.codec.LzopOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;

public class LzopCodec
extends LzoCodec {
    public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
        Configuration conf = this.getConf();
        LzoCompressor.CompressionStrategy strategy = LzoCodec.getCompressionStrategy(conf);
        int bufferSize = LzoCodec.getBufferSize(conf);
        return new LzopOutputStream(out, strategy, bufferSize);
    }

    public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
        return new LzopInputStream(in);
    }

    public Decompressor createDecompressor() {
        return null;
    }

    public String getDefaultExtension() {
        return ".lzo";
    }
}

