/*
 * Decompiled with CFR 0.152.
 */
package com.hadoop.compression.lzo;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.anarres.lzo.LzopInputStream;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;

public class LzoIndex {
    public static final String LZO_INDEX_SUFFIX = ".index";
    public static final String LZO_TMP_INDEX_SUFFIX = ".index.tmp";
    public static final long NOT_FOUND = -1L;
    private long[] blockPositions_;

    public LzoIndex() {
    }

    public LzoIndex(int blocks) {
        this.blockPositions_ = new long[blocks];
    }

    public void set(int blockNumber, long pos) {
        this.blockPositions_[blockNumber] = pos;
    }

    public int getNumberOfBlocks() {
        return this.blockPositions_.length;
    }

    public long getPosition(int block) {
        return this.blockPositions_[block];
    }

    public long findNextPosition(long pos) {
        int block = Arrays.binarySearch(this.blockPositions_, pos);
        if (block >= 0) {
            return this.blockPositions_[block];
        }
        if ((block = Math.abs(block) - 1) > this.blockPositions_.length - 1) {
            return -1L;
        }
        return this.blockPositions_[block];
    }

    public boolean isEmpty() {
        return this.blockPositions_ == null || this.blockPositions_.length == 0;
    }

    public long alignSliceStartToIndex(long start, long end) {
        if (start != 0L) {
            long newStart = this.findNextPosition(start);
            if (newStart == -1L || newStart >= end) {
                return -1L;
            }
            start = newStart;
        }
        return start;
    }

    public long alignSliceEndToIndex(long end, long fileSize) {
        long newEnd = this.findNextPosition(end);
        end = newEnd != -1L ? newEnd : fileSize;
        return end;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LzoIndex readIndex(FileSystem fs, Path lzoFile) throws IOException {
        FSDataInputStream indexIn = null;
        try {
            Path indexFile = lzoFile.suffix(LZO_INDEX_SUFFIX);
            if (!fs.exists(indexFile)) {
                LzoIndex lzoIndex = new LzoIndex();
                return lzoIndex;
            }
            long indexLen = fs.getFileStatus(indexFile).getLen();
            int blocks = (int)(indexLen / 8L);
            LzoIndex index = new LzoIndex(blocks);
            indexIn = fs.open(indexFile);
            for (int i = 0; i < blocks; ++i) {
                index.set(i, indexIn.readLong());
            }
            LzoIndex lzoIndex = index;
            return lzoIndex;
        }
        finally {
            if (indexIn != null) {
                indexIn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createIndex(FileSystem fs, Path lzoFile) throws IOException {
        Configuration conf = fs.getConf();
        CompressionCodecFactory factory = new CompressionCodecFactory(conf);
        CompressionCodec codec = factory.getCodec(lzoFile);
        if (null == codec) {
            throw new IOException("Could not find codec for file " + lzoFile + " - you may need to add the LZO codec to your io.compression.codecs configuration in core-site.xml");
        }
        ((Configurable)codec).setConf(conf);
        FSDataInputStream is = null;
        FSDataOutputStream os = null;
        Path outputFile = lzoFile.suffix(LZO_INDEX_SUFFIX);
        Path tmpOutputFile = lzoFile.suffix(LZO_TMP_INDEX_SUFFIX);
        boolean indexingSucceeded = false;
        try {
            int uncompressedBlockSize;
            is = fs.open(lzoFile);
            os = fs.create(tmpOutputFile);
            LzopInputStream lzis = new LzopInputStream((InputStream)is);
            int numCompressedChecksums = lzis.getCompressedChecksumCount();
            int numDecompressedChecksums = lzis.getUncompressedChecksumCount();
            while ((uncompressedBlockSize = is.readInt()) != 0) {
                if (uncompressedBlockSize < 0) {
                    throw new EOFException();
                }
                int compressedBlockSize = is.readInt();
                if (compressedBlockSize <= 0) {
                    throw new IOException("Could not read compressed block size");
                }
                boolean isUncompressedBlock = uncompressedBlockSize == compressedBlockSize;
                int numChecksumsToSkip = isUncompressedBlock ? numDecompressedChecksums : numDecompressedChecksums + numCompressedChecksums;
                long pos = is.getPos();
                os.writeLong(pos - 8L);
                is.seek(pos + (long)compressedBlockSize + (long)(4 * numChecksumsToSkip));
            }
            indexingSucceeded = true;
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
            if (!indexingSucceeded) {
                fs.delete(tmpOutputFile, false);
            } else {
                fs.rename(tmpOutputFile, outputFile);
            }
        }
    }
}

