/*
 * Decompiled with CFR 0.152.
 */
package com.hadoop.mapreduce;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.util.LineReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LzoLineRecordReader
extends RecordReader<LongWritable, Text> {
    private long start;
    private long pos;
    private long end;
    private LineReader in;
    private FSDataInputStream fileIn;
    private final LongWritable key = new LongWritable();
    private final Text value = new Text();

    public float getProgress() {
        if (this.start == this.end) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.pos - this.start) / (float)(this.end - this.start));
    }

    public synchronized long getPos() throws IOException {
        return this.pos;
    }

    public synchronized void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }

    public LongWritable getCurrentKey() throws IOException, InterruptedException {
        return this.key;
    }

    public Text getCurrentValue() throws IOException, InterruptedException {
        return this.value;
    }

    public void initialize(InputSplit genericSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        FileSplit split = (FileSplit)genericSplit;
        this.start = split.getStart();
        this.end = this.start + split.getLength();
        Path file = split.getPath();
        Configuration job = context.getConfiguration();
        FileSystem fs = file.getFileSystem(job);
        CompressionCodecFactory compressionCodecs = new CompressionCodecFactory(job);
        CompressionCodec codec = compressionCodecs.getCodec(file);
        if (codec == null) {
            throw new IOException("Codec for file " + file + " not found, cannot run");
        }
        this.fileIn = fs.open(split.getPath());
        this.in = new LineReader((InputStream)codec.createInputStream((InputStream)this.fileIn), job);
        if (this.start != 0L) {
            this.fileIn.seek(this.start);
            this.in.readLine(new Text());
            this.start = this.fileIn.getPos();
        }
        this.pos = this.start;
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.pos <= this.end) {
            this.key.set(this.pos);
            int newSize = this.in.readLine(this.value);
            if (newSize == 0) {
                return false;
            }
            this.pos = this.fileIn.getPos();
            return true;
        }
        return false;
    }
}

