/*
 * Decompiled with CFR 0.152.
 */
package org.anc;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import javax.swing.UIManager;

public abstract class Aspect {
    public static void setLookAndFeel() {
        Aspect.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    }

    public static boolean setLookAndFeel(String lookAndFeel) {
        boolean result = true;
        try {
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (Exception ex) {
            result = false;
        }
        return result;
    }

    public static void center(Component component) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension compSize = component.getSize();
        int x = (int)((screenSize.getWidth() - compSize.getWidth()) / 2.0);
        int y = (int)((screenSize.getHeight() - compSize.getHeight()) / 2.0);
        component.setLocation(x, y);
    }

    public static void center(Component parent, Component window) {
        if (parent == null) {
            Aspect.center(window);
            return;
        }
        Dimension size = parent.getSize();
        int x = parent.getX() + ((int)size.getWidth() - window.getWidth()) / 2;
        int y = parent.getY() + ((int)size.getHeight() - window.getHeight()) / 2;
        window.setLocation(x, y);
    }

    public static String fixSlashes(String s) {
        return s.replaceAll("\\\\", "/");
    }

    public static String encodeEntities(String s) {
        return s.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;");
    }

    public static boolean delete(File file) {
        if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                if (Aspect.delete(f)) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static void Catch(Exception e) {
        System.out.println(e);
        e.printStackTrace();
    }

    public static void Catch(Exception e, String message) {
        System.out.println(message);
        Aspect.Catch(e);
    }

    public static void CatchQuit(Exception e) {
        Aspect.CatchQuit(e, 1);
    }

    public static void CatchQuit(Exception e, String message) {
        System.out.println(message);
        Aspect.CatchQuit(e, 1);
    }

    public static void CatchQuit(Exception e, int code) {
        Aspect.Catch(e);
        System.exit(code);
    }
}

