/*
 * Decompiled with CFR 0.152.
 */
package org.anc.constants;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public abstract class Constants {
    private static final long serialVersionUID = 1L;
    private Map<String, String> variables = null;

    public void save() throws IOException {
        String name = this.getName();
        File file = new File(name);
        File parent = file.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new FileNotFoundException("Unable to create " + parent.getPath());
        }
        this.save(file);
    }

    public void save(String path) throws IOException {
        this.save(new File(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) throws IOException {
        Properties props = new Properties();
        Class<?> subclass = this.getClass();
        for (Field field : subclass.getDeclaredFields()) {
            String name = field.getName();
            if (!Constants.isPublicFinalString(field) && !Constants.isPublicFinalInteger(field) && !Constants.isPublicFinalFloat(field) && !Constants.isPublicFinalDouble(field) && !Constants.isPublicFinalBoolean(field)) continue;
            try {
                props.put(name, field.get(this).toString());
            }
            catch (Exception e) {
                throw new IOException("Unable to save field : " + name, e);
            }
        }
        try (FileOutputStream os = new FileOutputStream(file);){
            System.out.println("Wrote " + file.getPath());
            props.store(os, "Constants.");
        }
    }

    protected Properties getProperties(String propName) throws FileNotFoundException, IOException {
        Properties props = new Properties();
        String propValue = null;
        if (propName != null) {
            propValue = System.getProperty(propName);
            if (propValue != null) {
                props.load(new FileReader(propValue));
                return props;
            }
            propValue = System.getenv(propName);
            if (propValue != null) {
                props.load(new FileReader(propValue));
                return props;
            }
        }
        propValue = this.getName();
        InputStream in = null;
        File propFile = new File(propValue);
        if (propFile.exists()) {
            in = new FileInputStream(propFile);
        }
        if (in == null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = Constants.class.getClassLoader();
            }
            if ((in = loader.getResourceAsStream(propValue)) == null) {
                return new Properties();
            }
        }
        props.load(in);
        return props;
    }

    protected String getName() {
        Class<?> subclass = this.getClass();
        String name = null;
        if (name == null) {
            name = System.getenv("COMPUTERNAME");
        }
        if (name == null) {
            name = System.getenv("HOSTNAME");
        }
        if (name == null) {
            name = System.getProperty("user.name");
        }
        if (name == null) {
            name = "constants";
        }
        return "conf/" + name.toLowerCase() + "/" + subclass.getName() + ".properties";
    }

    protected void init() {
        this.init(null);
    }

    protected void init(String propertyName) {
        Field[] fields;
        Properties props;
        this.variables = new HashMap<String, String>();
        try {
            props = this.getProperties(propertyName);
        }
        catch (Exception e) {
            System.err.println("Unable to load properties from " + propertyName);
            e.printStackTrace();
            props = new Properties();
        }
        Class<?> subclass = this.getClass();
        for (Field field : fields = subclass.getDeclaredFields()) {
            String value = this.getInitValue(props, field);
            if (value == null) continue;
            if (Constants.isPublicFinalString(field)) {
                this.set(field, value);
                continue;
            }
            if (Constants.isPublicFinalInteger(field)) {
                this.set(field, new Integer(value));
                continue;
            }
            if (Constants.isPublicFinalFloat(field)) {
                this.set(field, new Float(value));
                continue;
            }
            if (Constants.isPublicFinalDouble(field)) {
                this.set(field, new Double(value));
                continue;
            }
            if (!Constants.isPublicFinalBoolean(field)) continue;
            this.set(field, new Boolean(value));
        }
        this.variables = null;
    }

    private String getInitValue(Properties props, Field field) {
        String sValue = props.getProperty(field.getName());
        if (sValue == null) {
            Default defaultValue = field.getAnnotation(Default.class);
            if (defaultValue == null) {
                return null;
            }
            sValue = defaultValue.value();
        }
        return this.replaceVariables(sValue);
    }

    private String replaceVariables(String input) {
        int index = input.indexOf(36);
        while (index >= 0) {
            String key;
            String value;
            int end = input.indexOf(47, index);
            if (end < index) {
                end = input.length();
            }
            if ((value = this.variables.get(key = input.substring(index + 1, end))) != null) {
                String prefix = input.substring(0, index);
                input = prefix + value + input.substring(end);
                index = input.indexOf(36, prefix.length());
                continue;
            }
            index = input.indexOf(36, end);
        }
        return input;
    }

    private void set(Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(this, value);
            if (value instanceof String) {
                this.variables.put(field.getName(), value.toString());
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    protected static boolean isPublicFinalString(Field field) {
        return Constants.isType(String.class, field);
    }

    protected static boolean isPublicFinalInteger(Field field) {
        return Constants.isType(Integer.class, field);
    }

    protected static boolean isPublicFinalDouble(Field field) {
        return Constants.isType(Double.class, field);
    }

    protected static boolean isPublicFinalFloat(Field field) {
        return Constants.isType(Float.class, field);
    }

    protected static boolean isPublicFinalBoolean(Field field) {
        return Constants.isType(Boolean.class, field);
    }

    private static boolean isType(Class<?> theClass, Field field) {
        int flags = field.getModifiers();
        return field.getType().equals(theClass) && Modifier.isPublic(flags) && Modifier.isFinal(flags) && !Modifier.isStatic(flags);
    }

    @Documented
    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Default {
        public String value();
    }
}

