/*
 * Decompiled with CFR 0.152.
 */
package org.anc.io;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Iterator;

public class DirectoryLister
implements Iterable<File> {
    private FileFilter filter = null;
    protected File directory;
    protected File[] listing = null;

    public DirectoryLister() {
    }

    public DirectoryLister(String directory) throws IOException {
        this(new File(directory));
    }

    public DirectoryLister(String directory, FileFilter filter) throws IOException {
        this(new File(directory), filter);
    }

    public DirectoryLister(File directory) throws IOException {
        if (!directory.isDirectory()) {
            throw new IOException(directory.getPath() + " is not a directory.");
        }
        this.directory = directory;
    }

    public DirectoryLister(File directory, FileFilter filter) throws IOException {
        if (!directory.isDirectory()) {
            throw new IOException(directory.getPath() + " is not a directory.");
        }
        this.directory = directory;
        this.filter = filter;
    }

    public int count() {
        this.getListing();
        return this.listing.length;
    }

    public boolean changeDirectory(String dir) {
        return this.changeDirectory(new File(dir));
    }

    public boolean changeDirectory(File dir) {
        if (!dir.isDirectory()) {
            return false;
        }
        this.listing = null;
        this.directory = dir;
        return true;
    }

    public void setFilter(FileFilter filter) {
        this.filter = filter;
    }

    @Override
    public Iterator<File> iterator() {
        this.getListing();
        return new DirectoryListerIterator();
    }

    protected void getListing() {
        if (this.listing == null) {
            this.listing = this.filter == null ? this.directory.listFiles() : this.directory.listFiles(this.filter);
        }
    }

    class DirectoryListerIterator
    implements Iterator<File> {
        private int index = 0;

        @Override
        public boolean hasNext() {
            return DirectoryLister.this.listing != null && this.index < DirectoryLister.this.listing.length;
        }

        @Override
        public File next() {
            if (!this.hasNext()) {
                return null;
            }
            File result = DirectoryLister.this.listing[this.index];
            ++this.index;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Can not call remove() on a DiretoryLister iterator.");
        }
    }
}

