/*
 * Decompiled with CFR 0.152.
 */
package org.anc.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class FileContentsIterator
implements Iterable<String> {
    protected File file;

    public FileContentsIterator(File file) throws FileNotFoundException {
        this.file = file;
    }

    @Override
    public java.util.Iterator<String> iterator() {
        return new Iterator();
    }

    class Iterator
    implements java.util.Iterator<String> {
        protected BufferedReader in;
        protected String line;
        protected IOException error = null;

        public Iterator() {
            try {
                this.in = new BufferedReader(new FileReader(FileContentsIterator.this.file));
                this.line = this.in.readLine();
            }
            catch (IOException e) {
                this.error = e;
                this.line = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.line != null;
        }

        @Override
        public String next() {
            String result = this.line;
            try {
                this.line = this.in.readLine();
            }
            catch (IOException e) {
                this.error = e;
                return null;
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Unable to remove content from a file with this method.");
        }

        public IOException getError() {
            return this.error;
        }
    }
}

