/*
 * Decompiled with CFR 0.152.
 */
package org.anc.io;

import java.io.File;
import java.io.FileFilter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PatternFilter
implements FileFilter {
    private Pattern pattern = null;
    private boolean listDirectories = true;

    public PatternFilter() {
    }

    public PatternFilter(String regex) {
        this(regex, true);
    }

    public PatternFilter(String regex, boolean listDirectories) {
        if (regex != null) {
            regex = regex.replaceAll("\\.", "\\\\.");
            regex = regex.replaceAll("\\*", ".*");
            this.pattern = Pattern.compile(regex);
        }
        this.listDirectories = listDirectories;
    }

    @Override
    public boolean accept(File file) {
        if (this.pattern == null) {
            return file.isFile() || this.listDirectories;
        }
        if (file.isDirectory()) {
            return this.listDirectories;
        }
        String filename = file.getName();
        Matcher matcher = this.pattern.matcher(filename);
        return matcher.matches();
    }

    public static void main(String[] args) {
        PatternFilter filter = new PatternFilter("*.txt", false);
        filter.test("foo.txt", true);
        filter.test("foo.anc", false);
        filter.test("foo.xml", false);
        filter.test("foo.bar", false);
        filter.test("C:/", false);
        filter.test("/usr", false);
    }

    protected void test(String name, boolean expected) {
        if (this.accept(new File(name)) == expected) {
            System.out.println("passed");
        } else {
            System.out.println("failed");
        }
    }
}

