/*
 * Decompiled with CFR 0.152.
 */
package org.anc.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public class UTF16Reader
extends InputStreamReader {
    public static final String ENCODING = "UTF-16";
    public static final int BUFFER_SIZE = 4096;

    public UTF16Reader(InputStream in) throws UnsupportedEncodingException {
        super(in, ENCODING);
    }

    public UTF16Reader(String filename) throws FileNotFoundException, UnsupportedEncodingException {
        super((InputStream)new FileInputStream(filename), ENCODING);
    }

    public UTF16Reader(File file) throws FileNotFoundException, UnsupportedEncodingException {
        super((InputStream)new FileInputStream(file), ENCODING);
    }

    public String readString() throws FileNotFoundException, IOException {
        char[] buffer = new char[4096];
        StringBuilder builder = new StringBuilder();
        int nChars = this.read(buffer);
        while (nChars > 0) {
            builder.append(buffer, 0, nChars);
            nChars = this.read(buffer);
        }
        return builder.toString();
    }
}

