/*
 * Decompiled with CFR 0.152.
 */
package org.anc.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.anc.io.UTF8Reader;

public class ResourceLoader {
    private ResourceLoader() {
    }

    public static InputStream open(String name) {
        return ResourceLoader.getClassLoader().getResourceAsStream(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadString(String name) throws IOException {
        InputStream stream = ResourceLoader.open(name);
        if (stream == null) {
            throw new IOException("Resource not found: " + name);
        }
        String result = null;
        try (UTF8Reader reader = new UTF8Reader(stream);){
            result = reader.readString();
        }
        return result;
    }

    public static ClassLoader getClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ResourceLoader.class.getClassLoader();
        }
        return loader;
    }

    public static URL getResource(String name) {
        ClassLoader loader = ResourceLoader.getClassLoader();
        return loader.getResource(name);
    }
}

