/*
 * Decompiled with CFR 0.152.
 */
package org.anc.resource;

import java.io.Closeable;
import java.util.LinkedList;
import org.anc.resource.ResourceManagerCheckedException;
import org.anc.resource.ResourceManagerRuntimeException;

public class ResourceManager<T extends Closeable> {
    protected LinkedList<T> resources = new LinkedList();

    public T add(T resource) {
        if (resource == null) {
            return null;
        }
        this.resources.addFirst(resource);
        return resource;
    }

    public void close() throws ResourceManagerCheckedException {
        ResourceManagerCheckedException exception = null;
        ResourceManagerRuntimeException runtime = null;
        for (Closeable resource : this.resources) {
            try {
                resource.close();
            }
            catch (RuntimeException e) {
                if (runtime == null) {
                    runtime = new ResourceManagerRuntimeException(resource, e);
                    continue;
                }
                runtime = new ResourceManagerRuntimeException(resource, e, runtime);
            }
            catch (Exception e) {
                if (exception == null) {
                    exception = new ResourceManagerCheckedException(resource, e);
                    continue;
                }
                exception = new ResourceManagerCheckedException(resource, e, exception);
            }
        }
        if (runtime != null) {
            if (exception != null) {
                runtime.addCheckedExceptions(exception);
            }
            throw runtime;
        }
        if (exception != null) {
            throw exception;
        }
    }

    public void closeQuietly() {
        ResourceManagerRuntimeException exception = null;
        for (Closeable resource : this.resources) {
            try {
                resource.close();
            }
            catch (RuntimeException e) {
                if (exception != null) {
                    exception = new ResourceManagerRuntimeException(resource, e, exception);
                    continue;
                }
                exception = new ResourceManagerRuntimeException(resource, e);
            }
            catch (Exception exception2) {}
        }
        if (exception != null) {
            throw exception;
        }
    }

    public void closeAbruptly() {
        for (Closeable resource : this.resources) {
            try {
                resource.close();
            }
            catch (Exception exception) {}
        }
    }
}

