/*
 * Decompiled with CFR 0.152.
 */
package org.anc.resource;

import java.io.Closeable;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.anc.resource.ResourceManagerCheckedException;

public class ResourceManagerRuntimeException
extends RuntimeException {
    protected Closeable resource;
    protected RuntimeException ex;
    protected RuntimeException next;
    protected ResourceManagerCheckedException checked = null;

    public ResourceManagerRuntimeException(Closeable resource, RuntimeException ex) {
        this(resource, ex, null);
    }

    public ResourceManagerRuntimeException(Closeable resource, RuntimeException ex, RuntimeException next) {
        this.resource = resource;
        this.ex = ex;
        this.next = next;
    }

    public void addCheckedExceptions(ResourceManagerCheckedException e) {
        this.checked = e;
    }

    public Closeable getResource() {
        return this.resource;
    }

    public RuntimeException getException() {
        return this.ex;
    }

    public RuntimeException getNextException() {
        return this.next;
    }

    public ResourceManagerCheckedException getCheckedExceptions() {
        return this.checked;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream out) {
        out.println("Runtime Exceptions");
        this.ex.printStackTrace(out);
        if (this.next != null) {
            this.next.printStackTrace(out);
        }
        out.println();
        out.println("Checked Exceptions");
        this.checked.printStackTrace(out);
    }

    @Override
    public void printStackTrace(PrintWriter out) {
        out.println("Runtime Exceptions");
        this.ex.printStackTrace(out);
        if (this.next != null) {
            this.next.printStackTrace(out);
        }
        out.println();
        out.println("Checked Exceptions");
        this.checked.printStackTrace(out);
    }
}

