/*
 * Decompiled with CFR 0.152.
 */
package org.anc.threads;

import java.util.LinkedList;
import org.anc.threads.Haltable;
import org.anc.threads.IANCThreadListener;

public abstract class ANCThread
extends Thread
implements Haltable {
    private State state = State.STOPPED;
    private LinkedList<IANCThreadListener> listeners = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IANCThreadListener listener) {
        LinkedList<IANCThreadListener> linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IANCThreadListener listener) {
        LinkedList<IANCThreadListener> linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.remove(listener);
        }
    }

    public State state() {
        return this.state;
    }

    public synchronized boolean running() {
        while (this.state == State.PAUSED) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.state == State.RUNNING;
    }

    @Override
    public synchronized void halt() {
        this.state = State.HALTED;
        this.fire(Event.HALTED);
        this.notifyAll();
    }

    public synchronized void pause(long millis) {
        this.state = State.PAUSED;
        this.fire(Event.PAUSED);
        try {
            ANCThread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.restart();
    }

    public synchronized void pause() {
        this.state = State.PAUSED;
        this.fire(Event.PAUSED);
    }

    public synchronized void restart() {
        this.state = State.RUNNING;
        this.fire(Event.RESUMED);
        this.notifyAll();
    }

    @Override
    public synchronized void start() {
        this.state = State.RUNNING;
        this.fire(Event.STARTED);
        super.start();
    }

    public synchronized void terminate() {
        this.state = State.TERMINATED;
        this.fire(Event.TERMINATED);
        this.notifyAll();
    }

    protected void fire(Event event) {
        for (IANCThreadListener listener : this.listeners) {
            listener.threadStateChanged(this, event);
        }
    }

    public static enum Event {
        STOPPED,
        STARTED,
        PAUSED,
        RESUMED,
        HALTED,
        TERMINATED;

    }

    public static enum State {
        STOPPED,
        RUNNING,
        PAUSED,
        HALTED,
        TERMINATED;

    }
}

